/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.mapreduce.input;

import com.google.common.collect.Lists;
import com.twitter.elephantbird.mapreduce.input.IntegerListInputSplit;
import com.twitter.elephantbird.mapreduce.input.IntegerListRecordReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class IntegerListInputFormat
extends InputFormat<LongWritable, NullWritable> {
    private static final Log LOG = LogFactory.getLog(IntegerListInputFormat.class);
    protected static long min = 1L;
    protected static long max = 1L;
    protected static long numSplits = 1L;

    public static void setListInterval(long max) {
        IntegerListInputFormat.setListInterval(1L, max);
    }

    public static void setListInterval(long min, long max) {
        IntegerListInputFormat.min = min;
        IntegerListInputFormat.max = max;
    }

    public static void setNumSplits(long numSplits) {
        IntegerListInputFormat.numSplits = numSplits;
    }

    public List<InputSplit> getSplits(JobContext jobContext) throws IOException, InterruptedException {
        ArrayList splits = Lists.newArrayList();
        long valuesPerSplit = 1L + (max - min) / numSplits;
        LOG.info((Object)("IntegerListInputFormat creating about " + numSplits + " splits for range [" + min + ", " + max + "], about " + valuesPerSplit + " values per split"));
        int i = 0;
        while ((long)i < numSplits) {
            long start = (long)i * valuesPerSplit + min;
            long stop = Math.min((long)(i + 1) * valuesPerSplit + min - 1L, max);
            if (start <= stop) {
                splits.add(new IntegerListInputSplit(start, stop));
            }
            ++i;
        }
        LOG.info((Object)("IntegerListInputFormat actually created " + splits.size() + " input splits."));
        return splits;
    }

    public RecordReader<LongWritable, NullWritable> createRecordReader(InputSplit inputSplit, TaskAttemptContext taskAttemptContext) throws IOException, InterruptedException {
        return new IntegerListRecordReader();
    }
}

