/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.elephantbird.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public abstract class TypeRef<T> {
    private final Type type_;
    private volatile Class class_;
    private volatile Constructor<?> constructor_;

    protected TypeRef() {
        Type superclass = this.getClass().getGenericSuperclass();
        if (!(superclass instanceof ParameterizedType)) {
            throw new RuntimeException("Missing type parameter.");
        }
        ParameterizedType parameterized = (ParameterizedType)superclass;
        this.type_ = parameterized.getActualTypeArguments()[0];
    }

    public TypeRef(Type genericType) {
        if (genericType == null) {
            throw new IllegalArgumentException("Type must not be null");
        }
        this.type_ = genericType;
    }

    private static Class getClass(Type type) {
        ParameterizedType parameterizedType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType() instanceof Class) {
            return (Class)parameterizedType.getRawType();
        }
        throw new IllegalArgumentException("Type parameter [" + type.toString() + "] not a class or " + "parameterized type whose raw type is a class");
    }

    public T newInstance() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        if (this.constructor_ == null) {
            this.constructor_ = this.getRawClass().getConstructor(new Class[0]);
        }
        return (T)this.constructor_.newInstance(new Object[0]);
    }

    public T safeNewInstance() {
        try {
            return this.newInstance();
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public final Type getType() {
        return this.type_;
    }

    public final Class<T> getRawClass() {
        if (this.class_ == null) {
            this.class_ = TypeRef.getClass(this.type_);
        }
        return this.class_;
    }
}

