/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Tweet information of the Tweet being replied to.")
public class TweetCreateRequestReply {
    public static final String SERIALIZED_NAME_EXCLUDE_REPLY_USER_IDS = "exclude_reply_user_ids";
    @SerializedName(value="exclude_reply_user_ids")
    private List<String> excludeReplyUserIds = null;
    public static final String SERIALIZED_NAME_IN_REPLY_TO_TWEET_ID = "in_reply_to_tweet_id";
    @SerializedName(value="in_reply_to_tweet_id")
    private String inReplyToTweetId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetCreateRequestReply excludeReplyUserIds(List<String> excludeReplyUserIds) {
        this.excludeReplyUserIds = excludeReplyUserIds;
        return this;
    }

    public TweetCreateRequestReply addExcludeReplyUserIdsItem(String excludeReplyUserIdsItem) {
        if (this.excludeReplyUserIds == null) {
            this.excludeReplyUserIds = new ArrayList<String>();
        }
        this.excludeReplyUserIds.add(excludeReplyUserIdsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A list of User Ids to be excluded from the reply Tweet.")
    public List<String> getExcludeReplyUserIds() {
        return this.excludeReplyUserIds;
    }

    public void setExcludeReplyUserIds(List<String> excludeReplyUserIds) {
        this.excludeReplyUserIds = excludeReplyUserIds;
    }

    public TweetCreateRequestReply inReplyToTweetId(String inReplyToTweetId) {
        this.inReplyToTweetId = inReplyToTweetId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1346889436626259968", required=true, value="Unique identifier of this Tweet. This is returned as a string in order to avoid complications with languages and tools that cannot handle large integers.")
    public String getInReplyToTweetId() {
        return this.inReplyToTweetId;
    }

    public void setInReplyToTweetId(String inReplyToTweetId) {
        this.inReplyToTweetId = inReplyToTweetId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetCreateRequestReply tweetCreateRequestReply = (TweetCreateRequestReply)o;
        return Objects.equals(this.excludeReplyUserIds, tweetCreateRequestReply.excludeReplyUserIds) && Objects.equals(this.inReplyToTweetId, tweetCreateRequestReply.inReplyToTweetId);
    }

    public int hashCode() {
        return Objects.hash(this.excludeReplyUserIds, this.inReplyToTweetId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetCreateRequestReply {\n");
        sb.append("    excludeReplyUserIds: ").append(this.toIndentedString(this.excludeReplyUserIds)).append("\n");
        sb.append("    inReplyToTweetId: ").append(this.toIndentedString(this.inReplyToTweetId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EXCLUDE_REPLY_USER_IDS) != null && !jsonObj.get(SERIALIZED_NAME_EXCLUDE_REPLY_USER_IDS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `exclude_reply_user_ids` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EXCLUDE_REPLY_USER_IDS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_IN_REPLY_TO_TWEET_ID) != null && !jsonObj.get(SERIALIZED_NAME_IN_REPLY_TO_TWEET_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `in_reply_to_tweet_id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IN_REPLY_TO_TWEET_ID).toString()));
        }
    }

    public static TweetCreateRequestReply fromJson(String jsonString) throws IOException {
        return (TweetCreateRequestReply)JSON.getGson().fromJson(jsonString, TweetCreateRequestReply.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EXCLUDE_REPLY_USER_IDS);
        openapiFields.add(SERIALIZED_NAME_IN_REPLY_TO_TWEET_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_IN_REPLY_TO_TWEET_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetCreateRequestReply.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetCreateRequestReply.class));
            return new TypeAdapter<TweetCreateRequestReply>(){

                public void write(JsonWriter out, TweetCreateRequestReply value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetCreateRequestReply read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetCreateRequestReply.validateJsonObject(jsonObj);
                    return (TweetCreateRequestReply)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

