/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;

public class Variant {
    public static final String SERIALIZED_NAME_BIT_RATE = "bit_rate";
    @SerializedName(value="bit_rate")
    private Integer bitRate;
    public static final String SERIALIZED_NAME_CONTENT_TYPE = "content_type";
    @SerializedName(value="content_type")
    private String contentType;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private URL url;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Variant bitRate(Integer bitRate) {
        this.bitRate = bitRate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The bit rate of the media.")
    public Integer getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(Integer bitRate) {
        this.bitRate = bitRate;
    }

    public Variant contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The content type of the media.")
    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public Variant url(URL url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The url to the media.")
    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Variant variant = (Variant)o;
        return Objects.equals(this.bitRate, variant.bitRate) && Objects.equals(this.contentType, variant.contentType) && Objects.equals(this.url, variant.url);
    }

    public int hashCode() {
        return Objects.hash(this.bitRate, this.contentType, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Variant {\n");
        sb.append("    bitRate: ").append(this.toIndentedString(this.bitRate)).append("\n");
        sb.append("    contentType: ").append(this.toIndentedString(this.contentType)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        if (jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `content_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CONTENT_TYPE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_URL) != null && !jsonObj.get(SERIALIZED_NAME_URL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `url` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_URL).toString()));
        }
    }

    public static Variant fromJson(String jsonString) throws IOException {
        return (Variant)JSON.getGson().fromJson(jsonString, Variant.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_BIT_RATE);
        openapiFields.add(SERIALIZED_NAME_CONTENT_TYPE);
        openapiFields.add(SERIALIZED_NAME_URL);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Variant.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Variant.class));
            return new TypeAdapter<Variant>(){

                public void write(JsonWriter out, Variant value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Variant read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Variant.validateJsonObject(jsonObj);
                    return (Variant)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }
}

