/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.util;

import com.unboundid.util.ByteStringBuffer;
import com.unboundid.util.Debug;
import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.UtilityMessages;
import com.unboundid.util.Validator;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class AggregateInputStream
extends InputStream {
    @Nullable
    private volatile InputStream activeInputStream;
    @NotNull
    private final Iterator<InputStream> streamIterator;

    public AggregateInputStream(InputStream ... inputStreams) {
        this(StaticUtils.toList(inputStreams));
    }

    public AggregateInputStream(@NotNull Collection<? extends InputStream> inputStreams) {
        Validator.ensureNotNull(inputStreams);
        ArrayList<? extends InputStream> streamList = new ArrayList<InputStream>(inputStreams);
        this.streamIterator = streamList.iterator();
        this.activeInputStream = null;
    }

    public AggregateInputStream(File ... files) throws IOException {
        this(false, files);
    }

    public AggregateInputStream(boolean ensureBlankLinesBetweenFiles, File ... files) throws IOException {
        Validator.ensureNotNull(files);
        ArrayList<InputStream> streamList = new ArrayList<InputStream>(2 * files.length);
        IOException ioException = null;
        for (File f : files) {
            if (ensureBlankLinesBetweenFiles && !streamList.isEmpty()) {
                ByteStringBuffer buffer = new ByteStringBuffer(4);
                buffer.append(StaticUtils.EOL_BYTES);
                buffer.append(StaticUtils.EOL_BYTES);
                streamList.add(new ByteArrayInputStream(buffer.toByteArray()));
            }
            try {
                streamList.add(new FileInputStream(f));
            }
            catch (IOException ioe) {
                Debug.debugException(ioe);
                ioException = ioe;
                break;
            }
        }
        if (ioException != null) {
            for (InputStream s : streamList) {
                if (s == null) continue;
                try {
                    s.close();
                }
                catch (Exception e) {
                    Debug.debugException(e);
                }
            }
            throw ioException;
        }
        this.streamIterator = streamList.iterator();
        this.activeInputStream = null;
    }

    @Override
    public int read() throws IOException {
        int byteRead;
        while (true) {
            if (this.activeInputStream == null) {
                if (this.streamIterator.hasNext()) {
                    this.activeInputStream = this.streamIterator.next();
                    continue;
                }
                return -1;
            }
            byteRead = this.activeInputStream.read();
            if (byteRead >= 0) break;
            this.activeInputStream.close();
            this.activeInputStream = null;
        }
        return byteRead;
    }

    @Override
    public int read(@NotNull byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        int bytesRead;
        while (true) {
            if (this.activeInputStream == null) {
                if (this.streamIterator.hasNext()) {
                    this.activeInputStream = this.streamIterator.next();
                    continue;
                }
                return -1;
            }
            bytesRead = this.activeInputStream.read(b, off, len);
            if (bytesRead >= 0) break;
            this.activeInputStream.close();
            this.activeInputStream = null;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.activeInputStream == null) {
            if (this.streamIterator.hasNext()) {
                this.activeInputStream = this.streamIterator.next();
                return this.activeInputStream.skip(n);
            }
            return 0L;
        }
        return this.activeInputStream.skip(n);
    }

    @Override
    public int available() throws IOException {
        if (this.activeInputStream == null) {
            if (this.streamIterator.hasNext()) {
                this.activeInputStream = this.streamIterator.next();
                return this.activeInputStream.available();
            }
            return 0;
        }
        return this.activeInputStream.available();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readLimit) {
    }

    @Override
    public void reset() throws IOException {
        throw new IOException(UtilityMessages.ERR_AGGREGATE_INPUT_STREAM_MARK_NOT_SUPPORTED.get());
    }

    @Override
    public void close() throws IOException {
        IOException firstException = null;
        if (this.activeInputStream != null) {
            try {
                this.activeInputStream.close();
            }
            catch (IOException ioe) {
                Debug.debugException(ioe);
                firstException = ioe;
            }
            this.activeInputStream = null;
        }
        while (this.streamIterator.hasNext()) {
            InputStream s = this.streamIterator.next();
            try {
                s.close();
            }
            catch (IOException ioe) {
                Debug.debugException(ioe);
                if (firstException != null) continue;
                firstException = ioe;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }
}

