/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.DefaultParsingContext;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.LineReader;
import com.univocity.parsers.common.ParserOutput;
import com.univocity.parsers.common.TextParsingException;
import com.univocity.parsers.common.input.CharInputReader;
import com.univocity.parsers.common.input.DefaultCharInputReader;
import com.univocity.parsers.common.input.EOFException;
import com.univocity.parsers.common.processor.RowProcessor;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractParser<T extends CommonParserSettings<?>> {
    protected final T settings;
    protected final ParserOutput output;
    private final int recordsToRead;
    private final char comment;
    private final LineReader lineReader = new LineReader();
    protected DefaultParsingContext context;
    protected RowProcessor processor;
    protected CharInputReader input;
    protected char ch;

    public AbstractParser(T settings) {
        this.settings = settings;
        this.output = new ParserOutput((CommonParserSettings<?>)settings);
        this.processor = ((CommonParserSettings)settings).getRowProcessor();
        this.recordsToRead = ((CommonParserSettings)settings).getNumberOfRecordsToRead();
        this.comment = ((Format)((CommonSettings)settings).getFormat()).getComment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void parse(Reader reader) {
        this.beginParsing(reader);
        try {
            while (!this.context.stopped) {
                this.ch = this.input.nextChar();
                if (this.ch == this.comment) {
                    this.input.skipLines(1);
                    continue;
                }
                this.parseRecord();
                String[] row = this.output.rowParsed();
                if (row == null) continue;
                this.processor.rowProcessed(row, this.context);
                if (this.recordsToRead <= 0 || this.context.currentRecord() < (long)this.recordsToRead) continue;
                this.context.stop();
            }
            this.stopParsing();
        }
        catch (EOFException ex) {
            try {
                this.handleEOF();
            }
            finally {
                this.stopParsing();
            }
        }
        catch (Throwable ex2) {
            try {
                TextParsingException ex2 = this.handleException(ex2);
                this.stopParsing(ex2);
            }
            catch (Throwable throwable) {
                this.stopParsing(ex2);
                throw throwable;
            }
        }
    }

    protected abstract void parseRecord();

    private String[] handleEOF() {
        String[] row = null;
        if (this.output.column != 0) {
            if (this.output.appender.length() > 0) {
                this.output.valueParsed();
            } else {
                this.output.emptyParsed();
            }
            row = this.output.rowParsed();
        } else if (this.output.appender.length() > 0) {
            this.output.valueParsed();
            row = this.output.rowParsed();
        }
        if (row != null) {
            this.processor.rowProcessed(row, this.context);
        }
        return row;
    }

    public final void beginParsing(Reader reader) {
        this.output.reset();
        this.input = reader instanceof LineReader ? new DefaultCharInputReader(((Format)((CommonSettings)this.settings).getFormat()).getLineSeparator(), ((Format)((CommonSettings)this.settings).getFormat()).getNormalizedNewline(), ((CommonParserSettings)this.settings).getInputBufferSize()) : ((CommonParserSettings)this.settings).newCharInputReader();
        this.context = new DefaultParsingContext(this.input, this.output);
        this.context.stopped = false;
        this.input.start(reader);
        this.processor.processStarted(this.context);
    }

    private TextParsingException handleException(Throwable ex) {
        String message = ex.getClass().getName() + " - " + ex.getMessage();
        char[] chars = this.output.appender.getChars();
        if (chars != null) {
            String tmp;
            int length = this.output.appender.length();
            if (length > chars.length) {
                message = "Length of parsed input (" + length + ") exceeds the maximum number of characters defined in your parser settings (" + ((CommonSettings)this.settings).getMaxCharsPerColumn() + "). ";
                length = chars.length;
            }
            if ((tmp = new String(chars)).contains("\n") || tmp.contains("\r")) {
                tmp = this.displayLineSeparators(tmp, true);
                String lineSeparator = this.displayLineSeparators(((Format)((CommonSettings)this.settings).getFormat()).getLineSeparatorString(), false);
                message = message + "\nIdentified line separator characters in the parsed content. This may be the cause of the error. The line separator in your parser settings is set to '" + lineSeparator + "'. Parsed content:\n\t" + tmp;
            }
            int nullCharacterCount = 0;
            int maxLength = length > 0x3FFFFFFF ? 0x3FFFFFFE : length;
            StringBuilder s = new StringBuilder(maxLength);
            for (int i = 0; i < maxLength; ++i) {
                if (chars[i] == '\u0000') {
                    s.append('\\');
                    s.append('0');
                    ++nullCharacterCount;
                    continue;
                }
                s.append(chars[i]);
            }
            tmp = s.toString();
            if (nullCharacterCount > 0) {
                message = message + "\nIdentified " + nullCharacterCount + " null characters ('\u0000') on parsed content. This may indicate the data is corrupt or its encoding is invalid. Parsed content:\n\t" + tmp;
            }
        }
        if (ex instanceof ArrayIndexOutOfBoundsException) {
            try {
                int index = Integer.parseInt(ex.getMessage());
                if (index == ((CommonSettings)this.settings).getMaxCharsPerColumn()) {
                    message = message + "\nHint: Number of characters processed may have exceeded limit of " + index + " characters per column. Use settings.setMaxCharsPerColumn(int) to define the maximum number of characters a column can have";
                }
                if (index == ((CommonSettings)this.settings).getMaxColumns()) {
                    message = message + "\nHint: Number of columns processed may have exceeded limit of " + index + " columns. Use settings.setMaxColumns(int) to define the maximum number of columns your input can have";
                }
                message = message + "\nEnsure your configuration is correct, with delimiters, quotes and escape sequences that match the input format you are trying to parse";
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        try {
            if (!message.isEmpty()) {
                message = message + "\n";
            }
            message = message + "Parser Configuration: " + ((CommonSettings)this.settings).toString();
        }
        catch (Exception t) {
            // empty catch block
        }
        return new TextParsingException(this.context, message, ex);
    }

    private String displayLineSeparators(String str, boolean addNewLine) {
        if (addNewLine) {
            str = str.contains("\r\n") ? str.replaceAll("\\r\\n", "[\\\\r\\\\n]\r\n\t") : (str.contains("\n") ? str.replaceAll("\\n", "[\\\\n]\n\t") : str.replaceAll("\\r", "[\\\\r]\r\t"));
        } else {
            str = str.replaceAll("\\n", "\\\\n");
            str = str.replaceAll("\\r", "\\\\r");
        }
        return str;
    }

    private final void stopParsing(Throwable error) {
        if (error != null) {
            try {
                this.stopParsing();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (error instanceof RuntimeException) {
                throw (RuntimeException)error;
            }
            if (error instanceof Error) {
                throw (Error)error;
            }
            throw new IllegalStateException(error.getMessage(), error);
        }
        this.stopParsing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopParsing() {
        try {
            this.context.stop();
        }
        finally {
            try {
                this.processor.processEnded(this.context);
            }
            finally {
                this.input.stop();
            }
        }
    }

    public final List<String[]> parseAll(Reader reader) {
        String[] row;
        ArrayList<String[]> out = new ArrayList<String[]>(10000);
        this.beginParsing(reader);
        while ((row = this.parseNext()) != null) {
            out.add(row);
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] parseNext() {
        try {
            while (!this.context.stopped) {
                this.ch = this.input.nextChar();
                if (this.ch == this.comment) {
                    this.input.skipLines(1);
                    continue;
                }
                this.parseRecord();
                String[] row = this.output.rowParsed();
                if (row == null) continue;
                this.processor.rowProcessed(row, this.context);
                if (this.recordsToRead > 0 && this.context.currentRecord() >= (long)this.recordsToRead) {
                    this.context.stop();
                }
                return row;
            }
            this.stopParsing();
            return null;
        }
        catch (EOFException ex) {
            String[] row = this.handleEOF();
            this.stopParsing();
            return row;
        }
        catch (NullPointerException ex) {
            if (this.context == null) {
                throw new IllegalStateException("Cannot parse without invoking method beginParsing(Reader) first");
            }
            if (this.input != null) {
                this.stopParsing();
            }
            throw new IllegalStateException("Error parsing next record.", ex);
        }
        catch (Throwable ex2) {
            try {
                TextParsingException ex2 = this.handleException(ex2);
                this.stopParsing(ex2);
            }
            catch (Throwable throwable) {
                this.stopParsing(ex2);
                throw throwable;
            }
            return null;
        }
    }

    protected final void reloadHeaders() {
        this.output.initializeHeaders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] parseLine(String line) {
        if (line == null || line.isEmpty()) {
            return null;
        }
        this.lineReader.setLine(line);
        if (this.context == null || this.context.isStopped()) {
            this.beginParsing(this.lineReader);
        } else {
            ((DefaultCharInputReader)this.input).reloadBuffer();
        }
        try {
            while (!this.context.stopped) {
                this.ch = this.input.nextChar();
                if (this.ch == this.comment) {
                    return null;
                }
                this.parseRecord();
                String[] row = this.output.rowParsed();
                if (row == null) continue;
                this.processor.rowProcessed(row, this.context);
                return row;
            }
            return null;
        }
        catch (EOFException ex) {
            return this.handleEOF();
        }
        catch (NullPointerException ex) {
            if (this.input != null) {
                this.stopParsing(null);
            }
            throw new IllegalStateException("Error parsing next record.", ex);
        }
        catch (Throwable ex2) {
            try {
                TextParsingException ex2 = this.handleException(ex2);
                this.stopParsing(ex2);
            }
            catch (Throwable throwable) {
                this.stopParsing(ex2);
                throw throwable;
            }
            return null;
        }
    }
}

