/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.fields;

import com.univocity.parsers.common.fields.AbstractConversionMapping;
import com.univocity.parsers.common.fields.AllIndexesSelector;
import com.univocity.parsers.common.fields.FieldIndexSelector;
import com.univocity.parsers.common.fields.FieldNameSelector;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.fields.FieldSet;
import com.univocity.parsers.conversions.Conversion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FieldConversionMapping {
    private List<FieldSelector> conversionSequence = new ArrayList<FieldSelector>();
    private AbstractConversionMapping<String> fieldNameConversionMapping = new AbstractConversionMapping<String>(this.conversionSequence){

        @Override
        protected FieldSelector newFieldSelector() {
            return new FieldNameSelector();
        }
    };
    private AbstractConversionMapping<Integer> fieldIndexConversionMapping = new AbstractConversionMapping<Integer>(this.conversionSequence){

        @Override
        protected FieldSelector newFieldSelector() {
            return new FieldIndexSelector();
        }
    };
    private AbstractConversionMapping<Integer> convertAllMapping = new AbstractConversionMapping<Integer>(this.conversionSequence){

        @Override
        protected FieldSelector newFieldSelector() {
            return new AllIndexesSelector();
        }
    };
    private Map<Integer, List<Conversion<?, ?>>> conversionsByIndex = Collections.emptyMap();

    public void prepareExecution(String[] values) {
        if (this.fieldNameConversionMapping.isEmpty() && this.fieldIndexConversionMapping.isEmpty() && this.convertAllMapping.isEmpty()) {
            return;
        }
        if (!this.conversionsByIndex.isEmpty()) {
            return;
        }
        this.conversionsByIndex = new HashMap();
        for (FieldSelector next : this.conversionSequence) {
            this.fieldNameConversionMapping.prepareExecution(next, this.conversionsByIndex, values);
            this.fieldIndexConversionMapping.prepareExecution(next, this.conversionsByIndex, values);
            this.convertAllMapping.prepareExecution(next, this.conversionsByIndex, values);
        }
    }

    public void applyConversionsOnAllFields(Conversion<String, ?> ... conversions) {
        this.convertAllMapping.registerConversions(conversions);
    }

    public FieldSet<Integer> applyConversionsOnFieldIndexes(Conversion<String, ?> ... conversions) {
        return this.fieldIndexConversionMapping.registerConversions(conversions);
    }

    public FieldSet<String> applyConversionsOnFieldNames(Conversion<String, ?> ... conversions) {
        return this.fieldNameConversionMapping.registerConversions(conversions);
    }

    public Object reverseConversions(boolean executeInReverseOrder, int index, Object value) {
        List<Conversion<?, ?>> conversions = this.conversionsByIndex.get(index);
        if (conversions != null) {
            Conversion<?, ?> conversion = null;
            try {
                if (executeInReverseOrder) {
                    for (int i = conversions.size() - 1; i >= 0; --i) {
                        conversion = conversions.get(i);
                        value = conversion.revert(value);
                    }
                } else {
                    for (Conversion<?, ?> c : conversions) {
                        conversion = c;
                        value = conversion.revert(value);
                    }
                }
            }
            catch (Throwable ex) {
                if (conversion != null) {
                    throw new IllegalStateException("Error converting value '" + value + "' using conversion " + conversion.getClass().getName(), ex);
                }
                throw new IllegalStateException("Error converting value '" + value + "'", ex);
            }
        }
        return value;
    }

    public Object applyConversions(int index, String stringValue) {
        List<Conversion<?, ?>> conversions = this.conversionsByIndex.get(index);
        if (conversions != null) {
            String result = stringValue;
            for (Conversion<?, ?> conversion : conversions) {
                try {
                    result = conversion.execute(result);
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Error converting value '" + result + "' using conversion " + conversion.getClass().getName(), ex);
                }
            }
            return result;
        }
        return stringValue;
    }
}

