/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.csv;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.TextParsingException;
import com.univocity.parsers.common.input.DefaultCharAppender;
import com.univocity.parsers.common.input.InputAnalysisProcess;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvFormatDetector;
import com.univocity.parsers.csv.CsvParserSettings;

public class CsvParser
extends AbstractParser<CsvParserSettings> {
    private final boolean ignoreTrailingWhitespace;
    private final boolean ignoreLeadingWhitespace;
    private final boolean parseUnescapedQuotes;
    private final boolean parseUnescapedQuotesUntilDelimiter;
    private final boolean doNotEscapeUnquotedValues;
    private final boolean keepEscape;
    private char delimiter;
    private char quote;
    private char quoteEscape;
    private final char escapeEscape;
    private final char newLine;
    private final DefaultCharAppender whitespaceAppender;
    private final boolean normalizeLineEndingsInQuotes;

    public CsvParser(CsvParserSettings settings) {
        super(settings);
        this.ignoreTrailingWhitespace = settings.getIgnoreTrailingWhitespaces();
        this.ignoreLeadingWhitespace = settings.getIgnoreLeadingWhitespaces();
        this.parseUnescapedQuotes = settings.isParseUnescapedQuotes();
        this.parseUnescapedQuotesUntilDelimiter = settings.isParseUnescapedQuotesUntilDelimiter();
        this.doNotEscapeUnquotedValues = !settings.isEscapeUnquotedValues();
        this.keepEscape = settings.isKeepEscapeSequences();
        this.normalizeLineEndingsInQuotes = settings.isNormalizeLineEndingsWithinQuotes();
        CsvFormat format = (CsvFormat)settings.getFormat();
        this.delimiter = format.getDelimiter();
        this.quote = format.getQuote();
        this.quoteEscape = format.getQuoteEscape();
        this.escapeEscape = format.getCharToEscapeQuoteEscaping();
        this.newLine = format.getNormalizedNewline();
        this.whitespaceAppender = new DefaultCharAppender(settings.getMaxCharsPerColumn(), "");
    }

    @Override
    protected void parseRecord() {
        if (this.ch <= ' ' && this.ignoreLeadingWhitespace) {
            this.skipWhitespace();
        }
        while (this.ch != this.newLine) {
            this.parseField();
            if (this.ch == this.newLine) continue;
            this.ch = this.input.nextChar();
            if (this.ch != this.newLine) continue;
            this.output.emptyParsed();
        }
    }

    private void parseValue() {
        if (this.ignoreTrailingWhitespace) {
            while (this.ch != this.delimiter && this.ch != this.newLine) {
                this.output.appender.appendIgnoringWhitespace(this.ch);
                this.ch = this.input.nextChar();
            }
        } else {
            while (this.ch != this.delimiter && this.ch != this.newLine) {
                this.output.appender.append(this.ch);
                this.ch = this.input.nextChar();
            }
        }
    }

    private void parseValueProcessingEscape(char prev) {
        if (this.ignoreTrailingWhitespace) {
            while (this.ch != this.delimiter && this.ch != this.newLine) {
                if (this.ch != this.quote && this.ch != this.quoteEscape) {
                    if (prev == this.quote) {
                        if (this.parseUnescapedQuotes) {
                            this.output.appender.append(this.quote);
                            this.parseValueProcessingEscape(this.ch);
                            break;
                        }
                        throw new TextParsingException(this.context, "Unescaped quote character '" + this.quote + "' inside value of CSV field. To allow unescaped quotes, set 'parseUnescapedQuotes' to 'true' in the CSV parser settings. Cannot parse CSV input.");
                    }
                    this.output.appender.appendIgnoringWhitespace(this.ch);
                } else if (this.ch == this.quoteEscape && prev == this.escapeEscape && this.escapeEscape != '\u0000') {
                    if (this.keepEscape) {
                        this.output.appender.appendIgnoringWhitespace(this.escapeEscape);
                    }
                    this.output.appender.appendIgnoringWhitespace(this.quoteEscape);
                    this.ch = '\u0000';
                } else if (prev == this.quoteEscape) {
                    if (this.ch == this.quote) {
                        if (this.keepEscape) {
                            this.output.appender.appendIgnoringWhitespace(this.quoteEscape);
                        }
                        this.output.appender.appendIgnoringWhitespace(this.quote);
                        this.ch = '\u0000';
                    } else {
                        this.output.appender.appendIgnoringWhitespace(prev);
                    }
                } else if (this.ch == this.quote && prev == this.quote) {
                    this.output.appender.appendIgnoringWhitespace(this.quote);
                }
                prev = this.ch;
                this.ch = this.input.nextChar();
            }
        } else {
            while (this.ch != this.delimiter && this.ch != this.newLine) {
                if (this.ch != this.quote && this.ch != this.quoteEscape) {
                    if (prev == this.quote) {
                        if (this.parseUnescapedQuotes) {
                            this.output.appender.append(this.quote);
                            this.parseValueProcessingEscape(this.ch);
                            break;
                        }
                        throw new TextParsingException(this.context, "Unescaped quote character '" + this.quote + "' inside value of CSV field. To allow unescaped quotes, set 'parseUnescapedQuotes' to 'true' in the CSV parser settings. Cannot parse CSV input.");
                    }
                    this.output.appender.append(this.ch);
                } else if (this.ch == this.quoteEscape && prev == this.escapeEscape && this.escapeEscape != '\u0000') {
                    if (this.keepEscape) {
                        this.output.appender.append(this.escapeEscape);
                    }
                    this.output.appender.append(this.quoteEscape);
                    this.ch = '\u0000';
                } else if (prev == this.quoteEscape) {
                    if (this.ch == this.quote) {
                        if (this.keepEscape) {
                            this.output.appender.append(this.quoteEscape);
                        }
                        this.output.appender.append(this.quote);
                        this.ch = '\u0000';
                    } else {
                        this.output.appender.append(prev);
                    }
                } else if (this.ch == this.quote && prev == this.quote) {
                    this.output.appender.appendIgnoringWhitespace(this.quote);
                }
                prev = this.ch;
                this.ch = this.input.nextChar();
            }
        }
    }

    private void parseQuotedValue(char prev) {
        this.ch = this.input.nextChar();
        while (prev != this.quote || this.ch > ' ' && this.ch != this.delimiter && this.ch != this.newLine) {
            if (this.ch != this.quote && this.ch != this.quoteEscape) {
                if (prev == this.quote) {
                    if (this.parseUnescapedQuotes) {
                        this.output.appender.append(this.quote);
                        this.output.appender.append(this.ch);
                        this.parseQuotedValue(this.ch);
                        break;
                    }
                    throw new TextParsingException(this.context, "Unescaped quote character '" + this.quote + "' inside quoted value of CSV field. To allow unescaped quotes, set 'parseUnescapedQuotes' to 'true' in the CSV parser settings. Cannot parse CSV input.");
                }
                this.output.appender.append(this.ch);
            } else if (this.ch == this.quoteEscape && prev == this.escapeEscape && this.escapeEscape != '\u0000') {
                if (this.keepEscape) {
                    this.output.appender.append(this.escapeEscape);
                }
                this.output.appender.append(this.quoteEscape);
                this.ch = '\u0000';
            } else if (prev == this.quoteEscape) {
                if (this.ch == this.quote) {
                    if (this.keepEscape) {
                        this.output.appender.append(this.quoteEscape);
                    }
                    this.output.appender.append(this.quote);
                    this.ch = '\u0000';
                } else {
                    this.output.appender.append(prev);
                }
            } else if (this.ch == this.quote && prev == this.quote) {
                this.output.appender.append(this.quote);
            }
            prev = this.ch;
            this.ch = this.input.nextChar();
        }
        if (this.ch != this.delimiter && this.ch != this.newLine && this.ch <= ' ') {
            this.whitespaceAppender.reset();
            do {
                this.whitespaceAppender.append(this.ch);
                this.ch = this.input.nextChar();
                if (this.ch != this.newLine) continue;
                return;
            } while (this.ch <= ' ');
            if (this.ch != this.delimiter && this.parseUnescapedQuotes) {
                if (this.output.appender instanceof DefaultCharAppender) {
                    this.output.appender.append(this.quote);
                    ((DefaultCharAppender)this.output.appender).append(this.whitespaceAppender);
                }
                if (this.ch != this.quote && this.ch != this.quoteEscape) {
                    this.output.appender.append(this.ch);
                }
                if (this.parseUnescapedQuotesUntilDelimiter) {
                    this.output.appender.prepend(this.quote);
                    this.ch = this.input.nextChar();
                    this.parseValue();
                } else {
                    this.parseQuotedValue(this.ch);
                }
            }
        }
        if (this.ch != this.delimiter && this.ch != this.newLine) {
            throw new TextParsingException(this.context, "Unexpected character '" + this.ch + "' following quoted value of CSV field. Expecting '" + this.delimiter + "'. Cannot parse CSV input.");
        }
    }

    private void parseField() {
        if (this.ch <= ' ' && this.ignoreLeadingWhitespace) {
            this.skipWhitespace();
        }
        if (this.ch == this.delimiter) {
            this.output.emptyParsed();
        } else {
            if (this.ch == this.quote) {
                if (this.normalizeLineEndingsInQuotes) {
                    this.parseQuotedValue('\u0000');
                } else {
                    this.input.enableNormalizeLineEndings(false);
                    this.parseQuotedValue('\u0000');
                    this.input.enableNormalizeLineEndings(true);
                }
            } else if (this.doNotEscapeUnquotedValues) {
                this.parseValue();
            } else {
                this.parseValueProcessingEscape('\u0000');
            }
            this.output.valueParsed();
        }
    }

    private void skipWhitespace() {
        while (this.ch <= ' ' && this.ch != this.delimiter && this.ch != this.newLine) {
            this.ch = this.input.nextChar();
        }
    }

    @Override
    protected InputAnalysisProcess getInputAnalysisProcess() {
        if (((CsvParserSettings)this.settings).isDelimiterDetectionEnabled() || ((CsvParserSettings)this.settings).isQuoteDetectionEnabled()) {
            return new CsvFormatDetector(20, (CsvParserSettings)this.settings){

                @Override
                void apply(char delimiter, char quote, char quoteEscape) {
                    if (((CsvParserSettings)CsvParser.this.settings).isDelimiterDetectionEnabled()) {
                        CsvParser.this.delimiter = delimiter;
                    }
                    if (((CsvParserSettings)CsvParser.this.settings).isQuoteDetectionEnabled()) {
                        CsvParser.this.quote = quote;
                        CsvParser.this.quoteEscape = quoteEscape;
                    }
                }
            };
        }
        return null;
    }

    public final CsvFormat getDetectedFormat() {
        CsvFormat out = null;
        if (((CsvParserSettings)this.settings).isDelimiterDetectionEnabled()) {
            out = ((CsvFormat)((CsvParserSettings)this.settings).getFormat()).clone();
            out.setDelimiter(this.delimiter);
        }
        if (((CsvParserSettings)this.settings).isQuoteDetectionEnabled()) {
            out = out == null ? ((CsvFormat)((CsvParserSettings)this.settings).getFormat()).clone() : out;
            out.setQuote(this.quote);
            out.setQuoteEscape(this.quoteEscape);
        }
        if (((CsvParserSettings)this.settings).isLineSeparatorDetectionEnabled()) {
            out = out == null ? ((CsvFormat)((CsvParserSettings)this.settings).getFormat()).clone() : out;
            out.setLineSeparator(this.input.getLineSeparator());
        }
        return out;
    }
}

