/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.csv;

import com.univocity.parsers.common.AbstractWriter;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvWriterSettings;
import java.io.File;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;

public class CsvWriter
extends AbstractWriter<CsvWriterSettings> {
    private char separator;
    private char quoteChar;
    private char escapeChar;
    private char escapeEscape;
    private boolean ignoreLeading;
    private boolean ignoreTrailing;
    private boolean quoteAllFields;
    private boolean escapeUnquoted;
    private boolean inputNotEscaped;
    private char newLine;
    private boolean dontProcessNormalizedNewLines;
    private boolean[] quotationTriggers;
    private char maxTrigger;

    public CsvWriter(CsvWriterSettings settings) {
        this((Writer)null, settings);
    }

    public CsvWriter(Writer writer, CsvWriterSettings settings) {
        super(writer, settings);
    }

    public CsvWriter(File file, CsvWriterSettings settings) {
        super(file, settings);
    }

    public CsvWriter(File file, String encoding, CsvWriterSettings settings) {
        super(file, encoding, settings);
    }

    public CsvWriter(File file, Charset encoding, CsvWriterSettings settings) {
        super(file, encoding, settings);
    }

    public CsvWriter(OutputStream output, CsvWriterSettings settings) {
        super(output, settings);
    }

    public CsvWriter(OutputStream output, String encoding, CsvWriterSettings settings) {
        super(output, encoding, settings);
    }

    public CsvWriter(OutputStream output, Charset encoding, CsvWriterSettings settings) {
        super(output, encoding, settings);
    }

    @Override
    protected final void initialize(CsvWriterSettings settings) {
        int i;
        CsvFormat format = (CsvFormat)settings.getFormat();
        this.separator = format.getDelimiter();
        this.quoteChar = format.getQuote();
        this.escapeChar = format.getQuoteEscape();
        this.escapeEscape = ((CsvFormat)settings.getFormat()).getCharToEscapeQuoteEscaping();
        this.newLine = format.getNormalizedNewline();
        this.quoteAllFields = settings.getQuoteAllFields();
        this.ignoreLeading = settings.getIgnoreLeadingWhitespaces();
        this.ignoreTrailing = settings.getIgnoreTrailingWhitespaces();
        this.escapeUnquoted = settings.isEscapeUnquotedValues();
        this.inputNotEscaped = !settings.isInputEscaped();
        this.dontProcessNormalizedNewLines = !settings.isNormalizeLineEndingsWithinQuotes();
        this.quotationTriggers = null;
        this.maxTrigger = '\u0000';
        int triggerCount = settings.getQuotationTriggers().length;
        int offset = settings.isQuoteEscapingEnabled() ? 1 : 0;
        char[] tmp = Arrays.copyOf(settings.getQuotationTriggers(), triggerCount + offset);
        if (offset == 1) {
            tmp[triggerCount] = this.quoteChar;
        }
        for (i = 0; i < tmp.length; ++i) {
            if (this.maxTrigger >= tmp[i]) continue;
            this.maxTrigger = tmp[i];
        }
        if (this.maxTrigger != '\u0000') {
            this.maxTrigger = (char)(this.maxTrigger + '\u0001');
            this.quotationTriggers = new boolean[this.maxTrigger];
            Arrays.fill(this.quotationTriggers, false);
            for (i = 0; i < tmp.length; ++i) {
                this.quotationTriggers[tmp[i]] = true;
            }
        }
    }

    @Override
    protected void processRow(Object[] row) {
        for (int i = 0; i < row.length; ++i) {
            String nextElement;
            boolean isElementQuoted;
            if (i != 0) {
                this.appendToRow(this.separator);
            }
            if (isElementQuoted = this.quoteElement(nextElement = this.getStringValue(row[i]))) {
                if (this.dontProcessNormalizedNewLines) {
                    this.appender.enableDenormalizedLineEndings(false);
                }
                this.appender.append(this.quoteChar);
            }
            int originalLength = this.appender.length();
            this.append(isElementQuoted, nextElement);
            if (this.appender.length() == originalLength) {
                if (isElementQuoted) {
                    if (nextElement == null) {
                        this.append(false, this.nullValue);
                    } else {
                        this.append(true, this.emptyValue);
                    }
                } else {
                    this.append(false, this.nullValue);
                }
            }
            if (isElementQuoted) {
                this.appendValueToRow();
                this.appendToRow(this.quoteChar);
                if (!this.dontProcessNormalizedNewLines) continue;
                this.appender.enableDenormalizedLineEndings(true);
                continue;
            }
            this.appendValueToRow();
        }
    }

    private boolean quoteElement(String nextElement) {
        if (this.quoteAllFields) {
            return true;
        }
        if (nextElement == null) {
            return false;
        }
        int start = 0;
        if (this.ignoreLeading) {
            start = CsvWriter.skipLeadingWhitespace(nextElement);
        }
        if (start < nextElement.length() && nextElement.charAt(start) == this.quoteChar) {
            return true;
        }
        for (int j = start; j < nextElement.length(); ++j) {
            char nextChar = nextElement.charAt(j);
            if (nextChar != this.separator && nextChar != this.newLine && (nextChar >= this.maxTrigger || !this.quotationTriggers[nextChar])) continue;
            return true;
        }
        return false;
    }

    private void append(boolean isElementQuoted, String element) {
        if (element == null) {
            element = this.nullValue;
        }
        if (element == null) {
            return;
        }
        int start = 0;
        if (this.ignoreLeading) {
            start = CsvWriter.skipLeadingWhitespace(element);
        }
        if (this.ignoreTrailing) {
            for (int i = start; i < element.length(); ++i) {
                char nextChar = element.charAt(i);
                if (nextChar == this.quoteChar && (isElementQuoted || this.escapeUnquoted) && this.inputNotEscaped) {
                    this.appender.appendIgnoringWhitespace(this.escapeChar);
                } else if (nextChar == this.escapeChar && this.inputNotEscaped && this.escapeEscape != '\u0000' && (isElementQuoted || this.escapeUnquoted)) {
                    this.appender.appendIgnoringWhitespace(this.escapeEscape);
                }
                this.appender.appendIgnoringWhitespace(nextChar);
            }
        } else {
            for (int i = start; i < element.length(); ++i) {
                char nextChar = element.charAt(i);
                if (nextChar == this.quoteChar && (isElementQuoted || this.escapeUnquoted) && this.inputNotEscaped) {
                    this.appender.append(this.escapeChar);
                } else if (nextChar == this.escapeChar && this.inputNotEscaped && this.escapeEscape != '\u0000' && (isElementQuoted || this.escapeUnquoted)) {
                    this.appender.appendIgnoringWhitespace(this.escapeEscape);
                }
                this.appender.append(nextChar);
            }
        }
    }
}

