/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input.concurrent;

import com.univocity.parsers.common.input.AbstractCharInputReader;
import com.univocity.parsers.common.input.BomInput;
import com.univocity.parsers.common.input.concurrent.CharBucket;
import com.univocity.parsers.common.input.concurrent.ConcurrentCharLoader;
import java.io.Reader;

public class ConcurrentCharInputReader
extends AbstractCharInputReader {
    private ConcurrentCharLoader bucketLoader;
    private final int bucketSize;
    private final int bucketQuantity;

    public ConcurrentCharInputReader(char normalizedLineSeparator, int bucketSize, int bucketQuantity, int whitespaceRangeStart) {
        super(normalizedLineSeparator, whitespaceRangeStart);
        this.bucketSize = bucketSize;
        this.bucketQuantity = bucketQuantity;
    }

    public ConcurrentCharInputReader(char[] lineSeparator, char normalizedLineSeparator, int bucketSize, int bucketQuantity, int whitespaceRangeStart) {
        super(lineSeparator, normalizedLineSeparator, whitespaceRangeStart);
        this.bucketSize = bucketSize;
        this.bucketQuantity = bucketQuantity;
    }

    @Override
    public void stop() {
        if (this.bucketLoader != null) {
            this.bucketLoader.stopReading();
            this.bucketLoader.reportError();
            if (this.bucketLoader.notification != null) {
                BomInput.BytesProcessedNotification notification = this.bucketLoader.notification;
                this.bucketLoader = null;
                this.unwrapInputStream(notification);
            }
        }
    }

    @Override
    protected void setReader(Reader reader) {
        this.stop();
        this.bucketLoader = new ConcurrentCharLoader(reader, this.bucketSize, this.bucketQuantity);
        this.bucketLoader.reportError();
    }

    @Override
    protected void reloadBuffer() {
        CharBucket currentBucket = this.bucketLoader.nextBucket();
        this.bucketLoader.reportError();
        this.buffer = currentBucket.data;
        this.length = currentBucket.length;
    }
}

