/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.util.analytics;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Random;
import org.atmosphere.util.analytics.FocusPoint;
import org.atmosphere.util.analytics.URLBuildingStrategy;

public class GoogleAnalytics_v1_URLBuildingStrategy
implements URLBuildingStrategy {
    private final FocusPoint appFocusPoint;
    private final String googleAnalyticsTrackingCode;
    private String refererURL = "http://async-io.org";
    private static final String TRACKING_URL_Prefix = "http://www.google-analytics.com/__utm.gif";
    private static final Random random = new Random();
    private static String hostName = "localhost";

    public GoogleAnalytics_v1_URLBuildingStrategy(String appName, String googleAnalyticsTrackingCode) {
        this.googleAnalyticsTrackingCode = googleAnalyticsTrackingCode;
        this.appFocusPoint = new FocusPoint(appName);
    }

    public GoogleAnalytics_v1_URLBuildingStrategy(String appName, String appVersion, String googleAnalyticsTrackingCode) {
        this.googleAnalyticsTrackingCode = googleAnalyticsTrackingCode;
        this.appFocusPoint = new FocusPoint(appVersion, new FocusPoint(appName));
    }

    @Override
    public String buildURL(FocusPoint focusPoint) {
        int cookie = random.nextInt();
        int randomValue = random.nextInt(Integer.MAX_VALUE) - 1;
        long now = new Date().getTime();
        focusPoint.setParentTrackPoint(this.appFocusPoint);
        return "http://www.google-analytics.com/__utm.gif?utmwv=1&utmn=" + random.nextInt() + "&utmcs=UTF-8&utmsr=1440x900&utmsc=32-bit&utmul=en-us&utmje=1&utmfl=9.0%20%20r28&utmcr=1&utmdt=" + focusPoint.getContentTitle() + "&utmhn=" + hostName + "&utmr=" + this.refererURL + "&utmp=" + focusPoint.getContentURI() + "&utmac=" + this.googleAnalyticsTrackingCode + "&utmcc=__utma%3D'" + cookie + "." + randomValue + "." + now + "." + now + "." + now + ".2%3B%2B__utmb%3D" + cookie + "%3B%2B__utmc%3D" + cookie + "%3B%2B__utmz%3D" + cookie + "." + now + ".2.2.utmccn%3D(direct)%7Cutmcsr%3D(direct)%7Cutmcmd%3D(none)%3B%2B__utmv%3D" + cookie;
    }

    @Override
    public void setRefererURL(String refererURL) {
        this.refererURL = refererURL;
    }

    static {
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }
}

