/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.data.renderer;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.data.renderer.BasicRenderer;
import com.vaadin.flow.data.renderer.ClickableRenderer;
import com.vaadin.flow.data.renderer.Rendering;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.ElementFactory;
import com.vaadin.flow.function.ValueProvider;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NativeButtonRenderer<SOURCE>
extends BasicRenderer<SOURCE, String>
implements ClickableRenderer<SOURCE> {
    private List<ClickableRenderer.ItemClickListener<SOURCE>> listeners = new ArrayList<ClickableRenderer.ItemClickListener<SOURCE>>(1);

    public NativeButtonRenderer(String label) {
        this((ValueProvider<SOURCE, String>)(ValueProvider & Serializable)value -> label);
    }

    public NativeButtonRenderer(String label, ClickableRenderer.ItemClickListener<SOURCE> clickListener) {
        this(label);
        this.addItemClickListener(clickListener);
    }

    public NativeButtonRenderer(ValueProvider<SOURCE, String> labelProvider) {
        super(labelProvider);
    }

    public NativeButtonRenderer(ValueProvider<SOURCE, String> labelProvider, ClickableRenderer.ItemClickListener<SOURCE> clickListener) {
        this(labelProvider);
        this.addItemClickListener(clickListener);
    }

    @Override
    public Registration addItemClickListener(ClickableRenderer.ItemClickListener<SOURCE> listener) {
        this.listeners.add(listener);
        return (Registration & Serializable)() -> this.listeners.remove(listener);
    }

    @Override
    public List<ClickableRenderer.ItemClickListener<SOURCE>> getItemClickListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    protected String getTemplateForProperty(String property, Rendering<SOURCE> context) {
        String templatePropertyName = this.getTemplatePropertyName(context);
        String eventName = templatePropertyName + "_event";
        String disabledName = templatePropertyName + "_disabled";
        this.setEventHandler(eventName, this::onClick);
        return String.format("<button on-click=\"%s\" disabled=\"[[item.%s]]\">%s</button>", eventName, disabledName, property);
    }

    @Override
    public Component createComponent(SOURCE item) {
        Element button = ElementFactory.createButton((String)((String)this.getValueProvider().apply(item)));
        button.addEventListener("click", (DomEventListener & Serializable)event -> this.getItemClickListeners().forEach(listeners -> listeners.onItemClicked(item)));
        return ComponentUtil.componentFromElement((Element)button, Component.class, (boolean)true);
    }
}

