/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.plugin.maven;

import com.vaadin.flow.plugin.base.BuildFrontendUtil;
import com.vaadin.flow.plugin.base.PluginAdapterBase;
import com.vaadin.flow.plugin.base.PluginAdapterBuild;
import com.vaadin.flow.plugin.maven.FlowModeAbstractMojo;
import com.vaadin.flow.server.ExecutionFailedException;
import com.vaadin.flow.server.frontend.BundleValidationUtil;
import com.vaadin.flow.server.frontend.TaskCleanFrontendFiles;
import com.vaadin.pro.licensechecker.LicenseChecker;
import java.io.File;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="build-frontend", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.PROCESS_CLASSES)
public class BuildFrontendMojo
extends FlowModeAbstractMojo
implements PluginAdapterBuild {
    @Parameter(defaultValue="true")
    private boolean generateBundle;
    @Parameter(defaultValue="true")
    private boolean runNpmInstall;
    @Parameter(defaultValue="true")
    private boolean generateEmbeddableWebComponents;
    @Parameter(defaultValue="${project.basedir}/src/main/resources/META-INF/resources/frontend")
    private File frontendResourcesDirectory;
    @Parameter(defaultValue="true")
    private boolean optimizeBundle;
    @Parameter(property="vaadin.ci.build", defaultValue="false")
    private boolean ciBuild;
    @Parameter(property="vaadin.force.production.build", defaultValue="false")
    private boolean forceProductionBuild;
    @Parameter(property="vaadin.clean.build.frontend.files", defaultValue="true")
    private boolean cleanFrontendFiles;

    public void execute() throws MojoExecutionException, MojoFailureException {
        long start = System.nanoTime();
        TaskCleanFrontendFiles cleanTask = new TaskCleanFrontendFiles(this.npmFolder(), this.frontendDirectory(), this.getClassFinder());
        try {
            BuildFrontendUtil.runNodeUpdater((PluginAdapterBuild)this);
        }
        catch (ExecutionFailedException | URISyntaxException exception) {
            throw new MojoFailureException("Could not execute build-frontend goal", exception);
        }
        if (this.generateBundle() && BundleValidationUtil.needsBundleBuild((File)this.servletResourceOutputDirectory())) {
            try {
                BuildFrontendUtil.runFrontendBuild((PluginAdapterBase)this);
                if (this.cleanFrontendFiles()) {
                    cleanTask.execute();
                }
            }
            catch (ExecutionFailedException | URISyntaxException | TimeoutException exception) {
                throw new MojoExecutionException(exception.getMessage(), (Exception)exception);
            }
        }
        LicenseChecker.setStrictOffline((boolean)true);
        BuildFrontendUtil.validateLicenses((PluginAdapterBase)this);
        BuildFrontendUtil.updateBuildFile((PluginAdapterBuild)this);
        long ms = (System.nanoTime() - start) / 1000000L;
        this.getLog().info((CharSequence)("Build frontend completed in " + ms + " ms."));
    }

    protected boolean cleanFrontendFiles() {
        if (BuildFrontendMojo.isHillaUsed(this.project, this.frontendDirectory())) {
            return false;
        }
        return this.cleanFrontendFiles;
    }

    public File frontendResourcesDirectory() {
        return this.frontendResourcesDirectory;
    }

    public boolean generateBundle() {
        return this.generateBundle;
    }

    public boolean generateEmbeddableWebComponents() {
        return this.generateEmbeddableWebComponents;
    }

    public boolean optimizeBundle() {
        return this.optimizeBundle;
    }

    public boolean runNpmInstall() {
        return this.runNpmInstall;
    }

    public boolean ciBuild() {
        return this.ciBuild;
    }

    public boolean forceProductionBuild() {
        return this.forceProductionBuild;
    }

    public boolean compressBundle() {
        return true;
    }
}

