/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import com.vaadin.experimental.Feature;
import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.server.frontend.AbstractTaskClientGenerator;
import com.vaadin.flow.server.frontend.Options;
import java.io.File;
import java.util.ArrayList;

public class TaskGenerateFeatureFlags
extends AbstractTaskClientGenerator {
    private final Options options;

    TaskGenerateFeatureFlags(Options options) {
        this.options = options;
    }

    @Override
    protected String getFileContent() {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("// @ts-nocheck");
        lines.add("window.Vaadin = window.Vaadin || {};");
        lines.add("window.Vaadin.featureFlags = window.Vaadin.featureFlags || {};");
        FeatureFlags featureFlags = this.options.getFeatureFlags();
        featureFlags.getFeatures().forEach(feature -> lines.add(String.format("window.Vaadin.featureFlags.%s = %s;", feature.getId(), featureFlags.isEnabled((Feature)feature))));
        lines.add("export {};");
        return String.join((CharSequence)System.lineSeparator(), lines);
    }

    @Override
    protected File getGeneratedFile() {
        File frontendGeneratedDirectory = new File(this.options.getFrontendDirectory(), "generated/");
        return new File(frontendGeneratedDirectory, "vaadin-featureflags.js");
    }

    @Override
    protected boolean shouldGenerate() {
        return true;
    }
}

