/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.ConstantPoolKey;
import com.vaadin.flow.internal.JsonUtils;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import com.vaadin.flow.shared.Registration;
import elemental.json.Json;
import elemental.json.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PolymerEventListenerMap
extends NodeMap {
    private static final ArrayList<String> emptyArrayList = new ArrayList(0);
    private Map<String, List<String>> typeToExpressions;

    public PolymerEventListenerMap(StateNode node) {
        super(node);
    }

    public Registration add(String methodName, String[] eventDataExpressions) {
        ArrayList<String> eventData;
        assert (methodName != null);
        assert (eventDataExpressions != null);
        if (this.typeToExpressions == null) {
            this.typeToExpressions = new HashMap<String, List<String>>();
        }
        if (!this.contains(methodName)) {
            assert (emptyArrayList.isEmpty());
            this.typeToExpressions.put(methodName, emptyArrayList);
            this.put(methodName, PolymerEventListenerMap.createConstantPoolKey(emptyArrayList));
        }
        if (eventDataExpressions.length != 0 && (eventData = new ArrayList<String>((Collection)this.typeToExpressions.get(methodName))).addAll(Arrays.asList(eventDataExpressions))) {
            this.put(methodName, PolymerEventListenerMap.createConstantPoolKey(eventData));
            this.typeToExpressions.put(methodName, eventData);
        }
        return () -> this.removeListener(methodName);
    }

    private static ConstantPoolKey createConstantPoolKey(List<String> eventData) {
        return new ConstantPoolKey((JsonValue)eventData.stream().map(Json::create).collect(JsonUtils.asArray()));
    }

    private void removeListener(String eventType) {
        this.typeToExpressions.remove(eventType);
        this.remove(eventType);
    }
}

