/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend.scanner;

import com.vaadin.experimental.FeatureFlags;
import com.vaadin.flow.server.PwaConfiguration;
import com.vaadin.flow.server.frontend.scanner.ChunkInfo;
import com.vaadin.flow.server.frontend.scanner.ClassFinder;
import com.vaadin.flow.server.frontend.scanner.CssData;
import com.vaadin.flow.server.frontend.scanner.FrontendDependencies;
import com.vaadin.flow.server.frontend.scanner.FullDependenciesScanner;
import com.vaadin.flow.theme.AbstractTheme;
import com.vaadin.flow.theme.ThemeDefinition;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface FrontendDependenciesScanner
extends Serializable {
    public Map<String, String> getPackages();

    public Map<ChunkInfo, List<String>> getModules();

    public Map<ChunkInfo, List<String>> getModulesDevelopment();

    public Map<ChunkInfo, List<String>> getScripts();

    public Map<ChunkInfo, List<String>> getScriptsDevelopment();

    public Map<ChunkInfo, List<CssData>> getCss();

    public ThemeDefinition getThemeDefinition();

    public AbstractTheme getTheme();

    public Set<String> getClasses();

    public PwaConfiguration getPwaConfiguration();

    public static class FrontendDependenciesScannerFactory {
        public FrontendDependenciesScanner createScanner(boolean allDependenciesScan, ClassFinder finder, boolean generateEmbeddableWebComponents) {
            return this.createScanner(allDependenciesScan, finder, generateEmbeddableWebComponents, null);
        }

        public FrontendDependenciesScanner createScanner(boolean allDependenciesScan, ClassFinder finder, boolean generateEmbeddableWebComponents, FeatureFlags featureFlags) {
            if (allDependenciesScan) {
                return new FullDependenciesScanner(finder, featureFlags);
            }
            return new FrontendDependencies(finder, generateEmbeddableWebComponents, featureFlags);
        }
    }
}

