/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Unit;
import java.util.Optional;

public interface HasSize
extends HasElement {
    default public void setWidth(String width) {
        this.getElement().getStyle().setWidth(width);
    }

    default public void setWidth(float width, Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit can not be null");
        }
        this.setWidth(HasSize.getCssSize(width, unit));
    }

    default public void setMinWidth(String minWidth) {
        this.getElement().getStyle().set("min-width", minWidth);
    }

    default public void setMinWidth(float minWidth, Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit can not be null");
        }
        this.setMinWidth(HasSize.getCssSize(minWidth, unit));
    }

    default public void setMaxWidth(String maxWidth) {
        this.getElement().getStyle().set("max-width", maxWidth);
    }

    default public void setMaxWidth(float maxWidth, Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit can not be null");
        }
        this.setMaxWidth(HasSize.getCssSize(maxWidth, unit));
    }

    default public String getWidth() {
        return this.getElement().getStyle().get("width");
    }

    default public String getMinWidth() {
        return this.getElement().getStyle().get("min-width");
    }

    default public String getMaxWidth() {
        return this.getElement().getStyle().get("max-width");
    }

    default public Optional<Unit> getWidthUnit() {
        return Unit.getUnit(this.getWidth());
    }

    default public void setHeight(String height) {
        this.getElement().getStyle().setHeight(height);
    }

    default public void setHeight(float height, Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit can not be null");
        }
        this.setHeight(HasSize.getCssSize(height, unit));
    }

    default public void setMinHeight(String minHeight) {
        this.getElement().getStyle().set("min-height", minHeight);
    }

    default public void setMinHeight(float minHeight, Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit can not be null");
        }
        this.setMinHeight(HasSize.getCssSize(minHeight, unit));
    }

    default public void setMaxHeight(String maxHeight) {
        this.getElement().getStyle().set("max-height", maxHeight);
    }

    default public void setMaxHeight(float maxHeight, Unit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit can not be null");
        }
        this.setMaxHeight(HasSize.getCssSize(maxHeight, unit));
    }

    default public String getHeight() {
        return this.getElement().getStyle().get("height");
    }

    default public String getMinHeight() {
        return this.getElement().getStyle().get("min-height");
    }

    default public String getMaxHeight() {
        return this.getElement().getStyle().get("max-height");
    }

    default public Optional<Unit> getHeightUnit() {
        return Unit.getUnit(this.getHeight());
    }

    default public void setSizeFull() {
        this.setWidth("100%");
        this.setHeight("100%");
    }

    default public void setWidthFull() {
        this.setWidth("100%");
    }

    default public void setHeightFull() {
        this.setHeight("100%");
    }

    default public void setSizeUndefined() {
        this.setWidth(null);
        this.setHeight(null);
    }

    public static String getCssSize(float size, Unit unit) {
        if (size < 0.0f) {
            return null;
        }
        return size + unit.toString();
    }
}

