/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.frontend;

import elemental.json.Json;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Objects;

class VersionsJsonConverter {
    static final String VAADIN_CORE_NPM_PACKAGE = "@vaadin/vaadin-core";
    private static final String JS_VERSION = "jsVersion";
    private static final String NPM_NAME = "npmName";
    private static final String NPM_VERSION = "npmVersion";
    private final JsonObject convertedObject = Json.createObject();

    VersionsJsonConverter(JsonObject platformVersions) {
        this.collectDependencies(platformVersions);
    }

    JsonObject getConvertedJson() {
        return this.convertedObject;
    }

    private void collectDependencies(JsonObject obj) {
        for (String key : obj.keys()) {
            JsonValue value = obj.get(key);
            if (!(value instanceof JsonObject)) continue;
            JsonObject json = (JsonObject)value;
            if (json.hasKey(NPM_NAME)) {
                this.addDependency(json);
                continue;
            }
            this.collectDependencies(json);
        }
    }

    private void addDependency(JsonObject obj) {
        assert (obj.hasKey(NPM_NAME));
        String npmName = obj.getString(NPM_NAME);
        if (Objects.equals(npmName, VAADIN_CORE_NPM_PACKAGE)) {
            return;
        }
        if (obj.hasKey(NPM_VERSION)) {
            this.convertedObject.put(npmName, obj.getString(NPM_VERSION));
        } else if (obj.hasKey(JS_VERSION)) {
            this.convertedObject.put(npmName, obj.getString(JS_VERSION));
        } else {
            throw new IllegalStateException("Vaadin code versions file contains unexpected data: dependency '" + npmName + "' has no 'npmVersion'/'jsVersion' . Please report a bug in https://github.com/vaadin/platform/issues/new");
        }
    }
}

