/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.auth;

import com.vaadin.flow.server.auth.AccessAnnotationChecker;
import com.vaadin.flow.server.auth.AccessCheckResult;
import com.vaadin.flow.server.auth.NavigationAccessChecker;
import com.vaadin.flow.server.auth.NavigationContext;
import jakarta.annotation.security.DenyAll;
import jakarta.annotation.security.PermitAll;
import jakarta.annotation.security.RolesAllowed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotatedViewAccessChecker
implements NavigationAccessChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedViewAccessChecker.class);
    private final AccessAnnotationChecker accessAnnotationChecker;

    public AnnotatedViewAccessChecker() {
        this(new AccessAnnotationChecker());
    }

    public AnnotatedViewAccessChecker(AccessAnnotationChecker accessAnnotationChecker) {
        this.accessAnnotationChecker = accessAnnotationChecker;
    }

    @Override
    public AccessCheckResult check(NavigationContext context) {
        Class<?> targetView = context.getNavigationTarget();
        boolean hasAccess = this.accessAnnotationChecker.hasAccess(targetView, context.getPrincipal(), context::hasRole);
        LOGGER.debug("Access to view '{}' with path '{}' is {}", new Object[]{context.getNavigationTarget().getName(), context.getLocation().getPath(), hasAccess ? "allowed" : "denied"});
        if (hasAccess) {
            return context.allow();
        }
        String denyReason = this.isImplicitlyDenyAllAnnotated(targetView) ? "Consider adding one of the following annotations to make the view accessible: @AnonymousAllowed, @PermitAll, @RolesAllowed." : "Access is denied by annotations on the view.";
        return context.deny(denyReason);
    }

    private boolean isImplicitlyDenyAllAnnotated(Class<?> targetView) {
        return !targetView.isAnnotationPresent(DenyAll.class) && !targetView.isAnnotationPresent(PermitAll.class) && !targetView.isAnnotationPresent(RolesAllowed.class);
    }
}

