/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.startup;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.server.ServiceInitEvent;
import com.vaadin.flow.server.VaadinServiceInitListener;
import com.vaadin.hilla.EndpointController;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EndpointRegistryInitializer
implements VaadinServiceInitListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(EndpointRegistryInitializer.class);
    private static final String OPEN_API_PROD_RESOURCE_PATH = "/hilla-openapi.json";
    private final EndpointController endpointController;

    public EndpointRegistryInitializer(EndpointController endpointController) {
        this.endpointController = endpointController;
    }

    public void serviceInit(ServiceInitEvent event) {
        DeploymentConfiguration deploymentConfig = event.getSource().getDeploymentConfiguration();
        URL openApiResource = this.getOpenApiAsResource(deploymentConfig);
        this.endpointController.registerEndpoints(openApiResource);
    }

    private URL getOpenApiAsResource(DeploymentConfiguration deploymentConfig) {
        if (deploymentConfig.isProductionMode()) {
            return this.getClass().getResource(OPEN_API_PROD_RESOURCE_PATH);
        }
        Path openApiPathInDevMode = deploymentConfig.getProjectFolder().toPath().resolve(deploymentConfig.getBuildFolder()).resolve("hilla-openapi.json");
        try {
            return openApiPathInDevMode.toFile().exists() ? openApiPathInDevMode.toUri().toURL() : null;
        }
        catch (MalformedURLException e) {
            LOGGER.debug(String.format("%s Mode: Path %s to resource %s seems to be malformed/could not be parsed. ", deploymentConfig.getMode(), openApiPathInDevMode.toUri(), "hilla-openapi.json"), (Throwable)e);
            return null;
        }
    }
}

