/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.hilla.exception;

import com.vaadin.hilla.exception.EndpointException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class EndpointValidationException
extends EndpointException {
    private final transient List<ValidationErrorData> validationErrorData;

    public EndpointValidationException(ValidationErrorData data) {
        this(Collections.singletonList(Objects.requireNonNull(data, "At least one 'validation error' is required")));
    }

    public EndpointValidationException(List<ValidationErrorData> validationErrorData) {
        this("Validation failed", validationErrorData);
    }

    public EndpointValidationException(String message, List<ValidationErrorData> validationErrorData) {
        super(message);
        if (validationErrorData == null || validationErrorData.isEmpty()) {
            throw new IllegalArgumentException("At least one 'validation error' is required");
        }
        this.validationErrorData = Collections.unmodifiableList(validationErrorData);
    }

    public List<ValidationErrorData> getValidationErrorData() {
        return this.validationErrorData;
    }

    @Override
    public Map<String, Object> getSerializationData() {
        HashMap<String, Object> serializationData = new HashMap<String, Object>(super.getSerializationData());
        serializationData.put("validationErrorData", this.validationErrorData);
        return serializationData;
    }

    public static class ValidationErrorData {
        private final String parameterName;
        private final String message;
        private final String validatorMessage;

        public ValidationErrorData(String message, String parameterName, String validatorMessage) {
            if (message == null || message.isEmpty()) {
                throw new IllegalArgumentException("Message cannot be null or empty");
            }
            this.parameterName = parameterName;
            this.message = message;
            this.validatorMessage = validatorMessage;
        }

        public ValidationErrorData(String message, String parameterName) {
            this(message, parameterName, null);
        }

        public ValidationErrorData(String message) {
            this(message, null);
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getMessage() {
            return this.message;
        }

        public String getValidatorMessage() {
            return this.validatorMessage;
        }
    }
}

