/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.base.devserver;

import com.vaadin.flow.server.VaadinContext;
import com.vaadin.flow.server.startup.ApplicationConfiguration;
import com.vaadin.open.Open;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserLauncher {
    private static final String LAUNCH_TRACKER = "LaunchUtil.hasLaunched";
    private static final String LAUNCHED_VALUE = "yes";
    private VaadinContext context;

    public BrowserLauncher(VaadinContext context) {
        this.context = context;
    }

    public void launchBrowserInDevelopmentMode(String url) {
        if (BrowserLauncher.isLaunched()) {
            return;
        }
        if (!this.isProductionMode()) {
            String outputOnFailure = "Application started at " + url;
            if (!Open.open((String)url)) {
                this.getLogger().info(outputOnFailure);
            }
            BrowserLauncher.setLaunched();
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(this.getClass());
    }

    private boolean isProductionMode() {
        ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.get((VaadinContext)this.context);
        return applicationConfiguration.isProductionMode();
    }

    private static boolean isLaunched() {
        return LAUNCHED_VALUE.equals(System.getProperty(LAUNCH_TRACKER));
    }

    private static void setLaunched() {
        System.setProperty(LAUNCH_TRACKER, LAUNCHED_VALUE);
    }
}

