/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldValueMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.ListMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TList;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolUtil;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public class DirInfo
implements TBase,
Serializable,
Cloneable,
Comparable<DirInfo> {
    private static final TStruct STRUCT_DESC = new TStruct("DirInfo");
    private static final TField ROOT_FIELD_DESC = new TField("root", 11, 1);
    private static final TField DATA_FIELD_DESC = new TField("data", 15, 2);
    public byte[] root;
    public List<byte[]> data;
    public static final int ROOT = 1;
    public static final int DATA = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public DirInfo() {
    }

    public DirInfo(byte[] root, List<byte[]> data) {
        this();
        this.root = root;
        this.data = data;
    }

    public static Builder builder() {
        return new Builder();
    }

    public DirInfo(DirInfo other) {
        if (other.isSetRoot()) {
            this.root = TBaseHelper.deepCopy(other.root);
        }
        if (other.isSetData()) {
            this.data = TBaseHelper.deepCopy(other.data);
        }
    }

    @Override
    public DirInfo deepCopy() {
        return new DirInfo(this);
    }

    public byte[] getRoot() {
        return this.root;
    }

    public DirInfo setRoot(byte[] root) {
        this.root = root;
        return this;
    }

    public void unsetRoot() {
        this.root = null;
    }

    public boolean isSetRoot() {
        return this.root != null;
    }

    public void setRootIsSet(boolean __value) {
        if (!__value) {
            this.root = null;
        }
    }

    public List<byte[]> getData() {
        return this.data;
    }

    public DirInfo setData(List<byte[]> data) {
        this.data = data;
        return this;
    }

    public void unsetData() {
        this.data = null;
    }

    public boolean isSetData() {
        return this.data != null;
    }

    public void setDataIsSet(boolean __value) {
        if (!__value) {
            this.data = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetRoot();
                    break;
                }
                this.setRoot((byte[])__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetData();
                    break;
                }
                this.setData((List)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getRoot();
            }
            case 2: {
                return this.getData();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof DirInfo)) {
            return false;
        }
        DirInfo that = (DirInfo)_that;
        if (!TBaseHelper.equalsSlow(this.isSetRoot(), that.isSetRoot(), this.root, that.root)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetData(), that.isSetData(), this.data, that.data);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.root, this.data});
    }

    @Override
    public int compareTo(DirInfo other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetRoot()).compareTo(other.isSetRoot());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.root, other.root);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetData()).compareTo(other.isSetData());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.data, other.data);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 11) {
                        this.root = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 15) {
                        TList _list60 = iprot.readListBegin();
                        this.data = new ArrayList<byte[]>(Math.max(0, _list60.size));
                        int _i61 = 0;
                        while (_list60.size < 0 ? iprot.peekList() : _i61 < _list60.size) {
                            byte[] _elem62 = iprot.readBinary();
                            this.data.add(_elem62);
                            ++_i61;
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.root != null) {
            oprot.writeFieldBegin(ROOT_FIELD_DESC);
            oprot.writeBinary(this.root);
            oprot.writeFieldEnd();
        }
        if (this.data != null) {
            oprot.writeFieldBegin(DATA_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.data.size()));
            for (byte[] _iter63 : this.data) {
                oprot.writeBinary(_iter63);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("DirInfo");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("root");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getRoot() == null) {
            sb.append("null");
        } else {
            int __root_size = Math.min(this.getRoot().length, 128);
            for (int i = 0; i < __root_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getRoot()[i]).length() > 1 ? Integer.toHexString(this.getRoot()[i]).substring(Integer.toHexString(this.getRoot()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getRoot()[i]).toUpperCase());
            }
            if (this.getRoot().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("data");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getData() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getData(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("root", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("data", 3, new ListMetaData(15, new FieldValueMetaData(11))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(DirInfo.class, metaDataMap);
    }

    public static class Builder {
        private byte[] root;
        private List<byte[]> data;

        public Builder setRoot(byte[] root) {
            this.root = root;
            return this;
        }

        public Builder setData(List<byte[]> data) {
            this.data = data;
            return this;
        }

        public DirInfo build() {
            DirInfo result = new DirInfo();
            result.setRoot(this.root);
            result.setData(this.data);
            return result;
        }
    }
}

