/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.client.storage;

import com.vesoft.nebula.client.graph.data.CASignedSSLParam;
import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.data.SSLParam;
import com.vesoft.nebula.client.graph.data.SelfSignedSSLParam;
import com.vesoft.nebula.storage.GraphStorageService;
import com.vesoft.nebula.storage.ScanEdgeRequest;
import com.vesoft.nebula.storage.ScanResponse;
import com.vesoft.nebula.storage.ScanVertexRequest;
import com.vesoft.nebula.util.SslUtil;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import javax.net.ssl.SSLSocketFactory;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.THeaderProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.THeaderTransport;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TSocket;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TTransportException;

public class GraphStorageConnection
implements Serializable {
    private static final long serialVersionUID = -3631352515689239788L;
    protected THeaderTransport transport = null;
    protected THeaderProtocol protocol = null;
    public HostAddress address;
    private GraphStorageService.Client client;

    protected GraphStorageConnection() {
    }

    protected GraphStorageConnection open(HostAddress address, int timeout, boolean enableSSL, SSLParam sslParam) throws Exception {
        int newTimeout;
        this.address = address;
        int n = newTimeout = timeout <= 0 ? Integer.MAX_VALUE : timeout;
        if (enableSSL) {
            SSLSocketFactory sslSocketFactory = sslParam.getSignMode() == SSLParam.SignMode.CA_SIGNED ? SslUtil.getSSLSocketFactoryWithCA((CASignedSSLParam)sslParam) : SslUtil.getSSLSocketFactoryWithoutCA((SelfSignedSSLParam)sslParam);
            try {
                this.transport = new THeaderTransport(new TSocket(sslSocketFactory.createSocket(InetAddress.getByName(address.getHost()).getHostAddress(), address.getPort()), newTimeout, newTimeout));
            }
            catch (IOException e) {
                throw new TTransportException(0, (Throwable)e);
            }
        } else {
            this.transport = new THeaderTransport(new TSocket(InetAddress.getByName(address.getHost()).getHostAddress(), address.getPort(), newTimeout, newTimeout));
            this.transport.open();
        }
        this.protocol = new THeaderProtocol(this.transport);
        this.client = new GraphStorageService.Client(this.protocol);
        return this;
    }

    public ScanResponse scanVertex(ScanVertexRequest request) throws TException {
        return this.client.scanVertex(request);
    }

    public ScanResponse scanEdge(ScanEdgeRequest request) throws TException {
        return this.client.scanEdge(request);
    }

    public void close() {
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
    }

    public HostAddress getAddress() {
        return this.address;
    }
}

