/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.encoder;

import com.vesoft.nebula.Coordinate;
import com.vesoft.nebula.Date;
import com.vesoft.nebula.DateTime;
import com.vesoft.nebula.Geography;
import com.vesoft.nebula.LineString;
import com.vesoft.nebula.Point;
import com.vesoft.nebula.Polygon;
import com.vesoft.nebula.PropertyType;
import com.vesoft.nebula.Time;
import com.vesoft.nebula.Value;
import com.vesoft.nebula.encoder.RowWriter;
import com.vesoft.nebula.encoder.SchemaProvider;
import com.vesoft.nebula.encoder.SchemaProviderImpl;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryFactory;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LinearRing;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.io.WKBWriter;

public class RowWriterImpl
implements RowWriter {
    private final SchemaProviderImpl schema;
    private final int headerLen;
    private int numNullBytes = 0;
    private boolean outOfSpaceStr = false;
    private long approxStrLen = 0L;
    private ByteBuffer buf;
    private final List<Boolean> isSet;
    private final List<byte[]> strList = new ArrayList<byte[]>();
    private ByteOrder byteOrder;
    static int[] andBits = new int[]{127, 191, 223, 239, 247, 251, 253, 254};
    static int[] orBits = new int[]{128, 64, 32, 16, 8, 4, 2, 1};
    static int[] nullBits = new int[]{128, 64, 32, 16, 8, 4, 2, 1};

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RowWriterImpl(SchemaProviderImpl schema, ByteOrder byteOrder) throws RuntimeException {
        byte header;
        this.byteOrder = byteOrder;
        if (schema == null) {
            throw new RuntimeException("Null schema object");
        }
        this.schema = schema;
        long ver = schema.getVersion();
        int schemaVerSize = 0;
        if (ver > 0L) {
            if (ver <= 255L) {
                header = 9;
                this.headerLen = 2;
                schemaVerSize = 1;
            } else if (ver < 65535L) {
                header = 10;
                this.headerLen = 3;
                schemaVerSize = 2;
            } else if (ver < 0xFFFFFFL) {
                header = 11;
                this.headerLen = 4;
                schemaVerSize = 3;
            } else if (ver < -1L) {
                header = 12;
                this.headerLen = 5;
                schemaVerSize = 4;
            } else if (ver < 0xFFFFFFFFFFL) {
                header = 13;
                this.headerLen = 6;
                schemaVerSize = 5;
            } else if (ver < 0xFFFFFFFFFFFFL) {
                header = 14;
                this.headerLen = 7;
                schemaVerSize = 6;
            } else {
                if (ver >= 0xFFFFFFFFFFFFFFL) throw new RuntimeException("Schema version too big");
                header = 15;
                this.headerLen = 8;
                schemaVerSize = 7;
            }
        } else {
            header = 8;
            this.headerLen = 1;
        }
        int numNullables = schema.getNumNullableFields();
        if (numNullables > 0) {
            this.numNullBytes = (numNullables - 1 >> 3) + 1;
        }
        this.buf = ByteBuffer.allocate(this.headerLen + this.numNullBytes + schema.size() + 8);
        this.buf.order(this.byteOrder);
        this.buf.put(header);
        if (ver > 0L) {
            ByteBuffer longBuf = ByteBuffer.allocate(8);
            longBuf.order(this.byteOrder);
            longBuf.putLong(ver);
            this.buf.put(longBuf.array(), 0, schemaVerSize);
        }
        this.isSet = new ArrayList<Boolean>(Collections.nCopies(schema.getNumFields(), false));
    }

    public SchemaProvider schema() {
        return this.schema;
    }

    @Override
    public void write(int index, boolean v) throws RuntimeException {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        int offset = this.headerLen + this.numNullBytes + field.offset();
        switch (typeEnum) {
            case BOOL: 
            case INT8: {
                if (v) {
                    this.buf.put(offset, (byte)1);
                    break;
                }
                this.buf.put(offset, (byte)0);
                break;
            }
            case INT16: {
                if (v) {
                    this.buf.put(offset, (byte)1);
                } else {
                    this.buf.put(offset, (byte)0);
                }
                this.buf.put(offset + 1, (byte)0);
                break;
            }
            case INT32: {
                if (v) {
                    this.buf.put(offset, (byte)1);
                } else {
                    this.buf.put(offset, (byte)0);
                }
                this.buf.put(offset + 1, (byte)0).put(offset + 2, (byte)0).put(offset + 3, (byte)0);
                break;
            }
            case TIMESTAMP: 
            case INT64: {
                if (v) {
                    this.buf.put(offset, (byte)1);
                } else {
                    this.buf.put(offset, (byte)0);
                }
                this.buf.put(offset + 1, (byte)0).put(offset + 2, (byte)0).put(offset + 3, (byte)0).put(offset + 4, (byte)0).put(offset + 5, (byte)0).put(offset + 6, (byte)0).put(offset + 7, (byte)0);
                break;
            }
            default: {
                throw new RuntimeException("Write boolean with unsupported type: " + field.type());
            }
        }
        if (field.nullable()) {
            this.clearNullBit(field.nullFlagPos());
        }
        this.isSet.set(index, true);
    }

    @Override
    public void write(int index, float v) {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        int offset = this.headerLen + this.numNullBytes + field.offset();
        switch (typeEnum) {
            case INT8: {
                if (v > 127.0f || v < 128.0f) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is byte");
                }
                this.buf.put(offset, (byte)v);
                break;
            }
            case INT16: {
                if (v > 32767.0f || v < 32768.0f) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is short");
                }
                this.buf.putShort(offset, (short)v);
                break;
            }
            case INT32: {
                if (v > 2.1474836E9f || v < -2.1474836E9f) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is int");
                }
                this.buf.putInt(offset, (int)v);
                break;
            }
            case TIMESTAMP: 
            case INT64: {
                if (v > 9.223372E18f || v < -9.223372E18f) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is long");
                }
                this.buf.putLong(offset, (long)v);
                break;
            }
            case FLOAT: {
                this.buf.putFloat(offset, v);
                break;
            }
            case DOUBLE: {
                this.buf.putDouble(offset, v);
                break;
            }
            default: {
                throw new RuntimeException("Value: " + v + "'s type is unexpected");
            }
        }
        if (field.nullable()) {
            this.clearNullBit(field.nullFlagPos());
        }
        this.isSet.set(index, true);
    }

    @Override
    public void write(int index, double v) {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        int offset = this.headerLen + this.numNullBytes + field.offset();
        switch (typeEnum) {
            case INT8: {
                if (v > 127.0 || v < 128.0) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is byte");
                }
                this.buf.put(offset, (byte)v);
                break;
            }
            case INT16: {
                if (v > 32767.0 || v < 32768.0) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is short");
                }
                this.buf.putShort(offset, (short)v);
                break;
            }
            case INT32: {
                if (v > 2.147483647E9 || v < -2.147483648E9) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is int");
                }
                this.buf.putInt(offset, (int)v);
                break;
            }
            case TIMESTAMP: 
            case INT64: {
                if (v > 9.223372036854776E18 || v < -9.223372036854776E18) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is long");
                }
                this.buf.putLong(offset, (long)v);
                break;
            }
            case FLOAT: {
                this.buf.putFloat(offset, (float)v);
                break;
            }
            case DOUBLE: {
                this.buf.putDouble(offset, v);
                break;
            }
            default: {
                throw new RuntimeException("Value: " + v + "'s type is unexpected");
            }
        }
        if (field.nullable()) {
            this.clearNullBit(field.nullFlagPos());
        }
        this.isSet.set(index, true);
    }

    @Override
    public void write(int index, byte v) {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        int offset = this.headerLen + this.numNullBytes + field.offset();
        switch (typeEnum) {
            case BOOL: {
                this.buf.put(offset, v == 0 ? (byte)0 : 1);
                break;
            }
            case INT8: {
                this.buf.put(offset, v);
                break;
            }
            case INT16: {
                this.buf.putShort(offset, v);
                break;
            }
            case INT32: {
                this.buf.putInt(offset, v);
                break;
            }
            case TIMESTAMP: 
            case INT64: {
                this.buf.putLong(offset, v);
                break;
            }
            case FLOAT: {
                this.buf.putFloat(offset, v);
                break;
            }
            case DOUBLE: {
                this.buf.putDouble(offset, v);
                break;
            }
            default: {
                throw new RuntimeException("Value: " + v + "'s type is unexpected");
            }
        }
        if (field.nullable()) {
            this.clearNullBit(field.nullFlagPos());
        }
        this.isSet.set(index, true);
    }

    @Override
    public void write(int index, short v) {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        int offset = this.headerLen + this.numNullBytes + field.offset();
        switch (typeEnum) {
            case BOOL: {
                this.buf.put(offset, v == 0 ? (byte)0 : 1);
                break;
            }
            case INT8: {
                if (v > 127 || v < -127) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is byte");
                }
                this.buf.put(offset, (byte)v);
                break;
            }
            case INT16: {
                this.buf.putShort(offset, v);
                break;
            }
            case INT32: {
                this.buf.putInt(offset, v);
                break;
            }
            case TIMESTAMP: 
            case INT64: {
                this.buf.putLong(offset, v);
                break;
            }
            case FLOAT: {
                this.buf.putFloat(offset, v);
                break;
            }
            case DOUBLE: {
                this.buf.putDouble(offset, v);
                break;
            }
            default: {
                throw new RuntimeException("Value: " + v + "'s type is unexpected");
            }
        }
        if (field.nullable()) {
            this.clearNullBit(field.nullFlagPos());
        }
        this.isSet.set(index, true);
    }

    @Override
    public void write(int index, int v) {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        int offset = this.headerLen + this.numNullBytes + field.offset();
        switch (typeEnum) {
            case BOOL: {
                this.buf.put(offset, v == 0 ? (byte)0 : 1);
                break;
            }
            case INT8: {
                if (v > 127 || v < -127) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is byte");
                }
                this.buf.put(offset, (byte)v);
                break;
            }
            case INT16: {
                if (v > Short.MAX_VALUE || v < -32767) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is short");
                }
                this.buf.putShort(offset, (short)v);
                break;
            }
            case INT32: {
                this.buf.putInt(offset, v);
                break;
            }
            case TIMESTAMP: 
            case INT64: {
                this.buf.putLong(offset, v);
                break;
            }
            case FLOAT: {
                this.buf.putFloat(offset, v);
                break;
            }
            case DOUBLE: {
                this.buf.putDouble(offset, v);
                break;
            }
            default: {
                throw new RuntimeException("Value: " + v + "'s type is unexpected");
            }
        }
        if (field.nullable()) {
            this.clearNullBit(field.nullFlagPos());
        }
        this.isSet.set(index, true);
    }

    @Override
    public void write(int index, long v) {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        int offset = this.headerLen + this.numNullBytes + field.offset();
        switch (typeEnum) {
            case BOOL: {
                this.buf.put(offset, v == 0L ? (byte)0 : 1);
                break;
            }
            case INT8: {
                if (v > 127L || v < -127L) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is byte");
                }
                this.buf.put(offset, (byte)v);
                break;
            }
            case INT16: {
                if (v > 32767L || v < -32767L) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is short");
                }
                this.buf.putShort(offset, (short)v);
                break;
            }
            case INT32: {
                if (v > Integer.MAX_VALUE || v < -2147483647L) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is int");
                }
                this.buf.putInt(offset, (int)v);
                break;
            }
            case INT64: {
                this.buf.putLong(offset, v);
                break;
            }
            case TIMESTAMP: {
                if (v < 0L || v > 9223372036L) {
                    throw new RuntimeException("Value: " + v + " is out of range, the type is timestamp");
                }
                this.buf.putLong(offset, v);
                break;
            }
            case FLOAT: {
                this.buf.putFloat(offset, v);
                break;
            }
            case DOUBLE: {
                this.buf.putDouble(offset, v);
                break;
            }
            default: {
                throw new RuntimeException("Value: " + v + "'s type is unexpected");
            }
        }
        if (field.nullable()) {
            this.clearNullBit(field.nullFlagPos());
        }
        this.isSet.set(index, true);
    }

    @Override
    public void write(int index, byte[] v) {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        int offset = this.headerLen + this.numNullBytes + field.offset();
        switch (typeEnum) {
            case GEOGRAPHY: 
            case STRING: {
                this.strList.add(v);
                this.outOfSpaceStr = true;
                this.approxStrLen += (long)v.length;
                break;
            }
            case FIXED_STRING: {
                byte[] fixStr;
                int len = Math.min(v.length, field.size());
                for (int i = 0; i < len; ++i) {
                    this.buf.put(offset + i, v[i]);
                }
                if (len >= field.size()) break;
                for (byte b : fixStr = new byte[field.size() - len]) {
                    this.buf.put(offset + len, b);
                }
                break;
            }
            default: {
                throw new RuntimeException("Value: " + new String(v) + "'s type is unexpected");
            }
        }
        if (field.nullable()) {
            this.clearNullBit(field.nullFlagPos());
        }
        this.isSet.set(index, true);
    }

    @Override
    public void write(int index, Time v) {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        int offset = this.headerLen + this.numNullBytes + field.offset();
        if (typeEnum != PropertyType.TIME) {
            throw new RuntimeException("Value: " + v + "'s type is unexpected");
        }
        this.buf.put(offset, v.hour).put(offset + 1, v.minute).put(offset + 2, v.sec).putInt(offset + 3, v.microsec);
        if (field.nullable()) {
            this.clearNullBit(field.nullFlagPos());
        }
        this.isSet.set(index, true);
    }

    @Override
    public void write(int index, Date v) {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        int offset = this.headerLen + this.numNullBytes + field.offset();
        switch (typeEnum) {
            case DATE: {
                this.buf.putShort(offset, v.year).put(offset + 2, v.month).put(offset + 2 + 1, v.day);
                break;
            }
            case DATETIME: {
                this.buf.putShort(offset, v.year).put(offset + 2, v.month).put(offset + 2 + 1, v.day).put(offset + 2 + 2, (byte)0).put(offset + 2 + 3, (byte)0).put(offset + 2 + 4, (byte)0).putInt(offset + 2 + 5, 0);
                break;
            }
            default: {
                throw new RuntimeException("Value: " + v + "'s type is unexpected");
            }
        }
        if (field.nullable()) {
            this.clearNullBit(field.nullFlagPos());
        }
        this.isSet.set(index, true);
    }

    @Override
    public void write(int index, DateTime v) {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        int offset = this.headerLen + this.numNullBytes + field.offset();
        switch (typeEnum) {
            case DATE: {
                this.buf.putShort(offset, v.year).put(offset + 2, v.month).put(offset + 2 + 1, v.day);
                break;
            }
            case DATETIME: {
                this.buf.putShort(offset, v.year).put(offset + 2, v.month).put(offset + 2 + 1, v.day).put(offset + 2 + 2, v.hour).put(offset + 2 + 3, v.minute).put(offset + 2 + 4, v.sec).putInt(offset + 2 + 5, v.microsec);
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        if (field.nullable()) {
            this.clearNullBit(field.nullFlagPos());
        }
        this.isSet.set(index, true);
    }

    @Override
    public void write(int index, Geography v) {
        SchemaProvider.Field field = this.schema.field(index);
        PropertyType typeEnum = PropertyType.findByValue(field.type());
        if (typeEnum == null) {
            throw new RuntimeException("Incorrect field type " + field.type());
        }
        if (typeEnum == PropertyType.GEOGRAPHY) {
            if (field.geoShape() != 0 && field.geoShape() != v.getSetField()) {
                throw new RuntimeException("Incorrect geo shape, expect " + field.geoShape() + ", got " + v.getSetField());
            }
        } else {
            throw new RuntimeException("Value: " + v + "'s type is unexpected");
        }
        Geometry jtsGeom = this.convertGeographyToJTSGeometry(v);
        byte[] wkb = new WKBWriter(2, this.byteOrder == ByteOrder.BIG_ENDIAN ? 1 : 2).write(jtsGeom);
        this.write(index, wkb);
    }

    @Override
    public byte[] encodeStr() {
        return this.buf.array();
    }

    public void setValue(String name, Object value) {
        int index = this.schema.getFieldIndex(name);
        if (index < 0) {
            throw new RuntimeException("Prop name `" + name + "' is not exist");
        }
        if (value == null) {
            throw new RuntimeException("Prop value `" + name + "' is null object");
        }
        this.setValue(index, value);
    }

    public void setValue(int index, Object value) {
        if (value instanceof Value) {
            this.setValue(index, (Value)value);
        } else if (value instanceof Boolean) {
            this.write(index, (Boolean)value);
        } else if (value instanceof Byte) {
            this.write(index, (Byte)value);
        } else if (value instanceof Short) {
            this.write(index, (Short)value);
        } else if (value instanceof Integer) {
            this.write(index, (Integer)value);
        } else if (value instanceof Long) {
            this.write(index, (Long)value);
        } else if (value instanceof String) {
            this.write(index, ((String)value).getBytes());
        } else if (value instanceof Float) {
            this.write(index, ((Float)value).floatValue());
        } else if (value instanceof Double) {
            this.write(index, (Double)value);
        } else if (value instanceof Time) {
            this.write(index, (Time)value);
        } else if (value instanceof Date) {
            this.write(index, (Date)value);
        } else if (value instanceof DateTime) {
            this.write(index, (DateTime)value);
        } else if (value instanceof Geography) {
            this.write(index, (Geography)value);
        } else {
            throw new RuntimeException("Unsupported value object `" + value.getClass() + "\"");
        }
    }

    public void setValue(String name, Value value) {
        int index = this.schema.getFieldIndex(name);
        if (index < 0) {
            throw new RuntimeException("Prop name `" + name + "' is not exist");
        }
        if (value == null) {
            throw new RuntimeException("Prop value `" + name + "' is null object");
        }
        this.setValue(index, value);
    }

    public void setValue(int index, Value value) {
        switch (value.getSetField()) {
            case 1: {
                this.setNull(index);
                break;
            }
            case 2: {
                this.write(index, value.isBVal());
                break;
            }
            case 3: {
                this.write(index, value.getIVal());
                break;
            }
            case 4: {
                this.write(index, value.getFVal());
                break;
            }
            case 5: {
                this.write(index, value.getSVal());
                break;
            }
            case 7: {
                this.write(index, value.getTVal());
                break;
            }
            case 6: {
                this.write(index, value.getDVal());
                break;
            }
            case 8: {
                this.write(index, value.getDtVal());
                break;
            }
            case 16: {
                this.write(index, value.getGgVal());
                break;
            }
            default: {
                throw new RuntimeException("Unknown value: " + value.getFieldValue().getClass() + "from index `" + index + "\"");
            }
        }
    }

    public void setNull(String name) {
        int index = this.schema.getFieldIndex(name);
        this.setNull(index);
    }

    public void setNull(int index) {
        if (index < 0 || index >= this.schema.getNumFields()) {
            throw new RuntimeException("Unknown filed from index `" + index + "\"");
        }
        SchemaProvider.Field field = this.schema.field(index);
        if (!field.nullable()) {
            throw new RuntimeException("Index `" + index + "\" is not nullable");
        }
        this.setNullBit(field.nullFlagPos());
        this.isSet.set(index, true);
    }

    private void setNullBit(int pos) {
        int offset = this.headerLen + (pos >> 3);
        this.buf.put(offset, (byte)(this.buf.get(offset) | orBits[(int)((long)pos & 7L)]));
    }

    private boolean checkNullBit(int pos) {
        int offset = this.headerLen + (pos >> 3);
        int flag = this.buf.get(offset) & nullBits[(int)((long)pos & 7L)];
        return flag != 0;
    }

    private void clearNullBit(int pos) {
        int offset = this.headerLen + (pos >> 3);
        this.buf.put(offset, (byte)(this.buf.get(offset) & andBits[(int)((long)pos & 7L)]));
    }

    public void checkUnsetFields() {
        for (int i = 0; i < this.schema.getNumFields(); ++i) {
            if (this.isSet.get(i).booleanValue()) continue;
            SchemaProvider.Field field = this.schema.field(i);
            if (!field.nullable() && !field.hasDefault()) {
                throw new RuntimeException("Filed: " + field.name() + " unset");
            }
            if (field.hasDefault()) {
                throw new RuntimeException("Unsupported default value yet");
            }
            this.setNullBit(field.nullFlagPos());
        }
    }

    public ByteBuffer processOutOfSpace() {
        ByteBuffer temp = ByteBuffer.allocate((int)((long)(this.headerLen + this.numNullBytes + this.schema.size()) + this.approxStrLen + 8L));
        temp.order(this.byteOrder);
        temp = temp.put(this.buf.array(), 0, this.buf.array().length - 8);
        int strOffset = this.buf.array().length - 8;
        int strNum = 0;
        for (int i = 0; i < this.schema.getNumFields(); ++i) {
            SchemaProvider.Field field = this.schema.field(i);
            PropertyType typeEnum = PropertyType.findByValue(field.type());
            if (typeEnum == null) {
                throw new RuntimeException("Incorrect field type " + field.type());
            }
            if (typeEnum != PropertyType.STRING && typeEnum != PropertyType.GEOGRAPHY) continue;
            int offset = this.headerLen + this.numNullBytes + field.offset();
            if (field.nullable() && this.checkNullBit(field.nullFlagPos())) {
                temp.putInt(offset, 0);
                temp.putInt(offset + 4, 0);
                continue;
            }
            if (strNum >= this.strList.size()) {
                throw new RuntimeException("Wrong strNum: " + strNum);
            }
            temp.put(this.strList.get(strNum));
            temp.putInt(offset, strOffset);
            int len = this.strList.get(strNum).length;
            temp.putInt(offset + 4, len);
            strOffset += len;
            ++strNum;
        }
        return temp;
    }

    public void finish() {
        this.checkUnsetFields();
        if (this.outOfSpaceStr) {
            this.buf = this.processOutOfSpace();
        }
        this.buf.putLong(this.buf.array().length - 8, this.getTimestamp());
    }

    private long getTimestamp() {
        long curTime = System.currentTimeMillis() * 1000L;
        long nanoTime = System.nanoTime();
        return curTime + (nanoTime - nanoTime / 1000000L * 1000000L) / 1000L;
    }

    public Geometry convertGeographyToJTSGeometry(Geography geog) {
        GeometryFactory geomFactory = new GeometryFactory();
        switch (geog.getSetField()) {
            case 1: {
                Point point = geog.getPtVal();
                Coordinate coord = point.getCoord();
                return geomFactory.createPoint(new org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate(coord.x, coord.y));
            }
            case 2: {
                LineString line = geog.getLsVal();
                List<Coordinate> coordList = line.getCoordList();
                ArrayList<org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate> jtsCoordList = new ArrayList<org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate>();
                for (int i = 0; i < coordList.size(); ++i) {
                    jtsCoordList.add(new org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate(coordList.get((int)i).x, coordList.get((int)i).y));
                }
                org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate[] jtsCoordArray = new org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate[jtsCoordList.size()];
                return geomFactory.createLineString(jtsCoordList.toArray(jtsCoordArray));
            }
            case 3: {
                Polygon polygon = geog.getPgVal();
                List<List<Coordinate>> coordListList = polygon.getCoordListList();
                if (coordListList.isEmpty()) {
                    throw new RuntimeException("Polygon must at least contain one loop");
                }
                ArrayList<LinearRing> rings = new ArrayList<LinearRing>();
                for (int i = 0; i < coordListList.size(); ++i) {
                    List<Coordinate> coordList = coordListList.get(i);
                    ArrayList<org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate> jtsCoordList = new ArrayList<org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate>();
                    for (int j = 0; j < coordList.size(); ++j) {
                        jtsCoordList.add(new org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate(coordList.get((int)j).x, coordList.get((int)j).y));
                    }
                    org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate[] jtsCoordArray = new org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate[jtsCoordList.size()];
                    rings.add(geomFactory.createLinearRing(jtsCoordList.toArray(jtsCoordArray)));
                }
                LinearRing shell = (LinearRing)rings.get(0);
                if (rings.size() == 1) {
                    return geomFactory.createPolygon(shell);
                }
                rings.remove(0);
                LinearRing[] holesArrary = new LinearRing[rings.size() - 1];
                return geomFactory.createPolygon(shell, rings.toArray(holesArrary));
            }
        }
        throw new RuntimeException("Unknown geography: " + geog.getFieldValue().getClass());
    }
}

