/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.vesoft.nebula.HostAddr;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldValueMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.StructMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolUtil;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public class AgentHBReq
implements TBase,
Serializable,
Cloneable,
Comparable<AgentHBReq> {
    private static final TStruct STRUCT_DESC = new TStruct("AgentHBReq");
    private static final TField HOST_FIELD_DESC = new TField("host", 12, 1);
    private static final TField GIT_INFO_SHA_FIELD_DESC = new TField("git_info_sha", 11, 2);
    private static final TField VERSION_FIELD_DESC = new TField("version", 11, 3);
    public HostAddr host;
    public byte[] git_info_sha;
    public byte[] version;
    public static final int HOST = 1;
    public static final int GIT_INFO_SHA = 2;
    public static final int VERSION = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public AgentHBReq() {
    }

    public AgentHBReq(HostAddr host, byte[] git_info_sha) {
        this();
        this.host = host;
        this.git_info_sha = git_info_sha;
    }

    public AgentHBReq(HostAddr host, byte[] git_info_sha, byte[] version) {
        this();
        this.host = host;
        this.git_info_sha = git_info_sha;
        this.version = version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public AgentHBReq(AgentHBReq other) {
        if (other.isSetHost()) {
            this.host = TBaseHelper.deepCopy(other.host);
        }
        if (other.isSetGit_info_sha()) {
            this.git_info_sha = TBaseHelper.deepCopy(other.git_info_sha);
        }
        if (other.isSetVersion()) {
            this.version = TBaseHelper.deepCopy(other.version);
        }
    }

    @Override
    public AgentHBReq deepCopy() {
        return new AgentHBReq(this);
    }

    public HostAddr getHost() {
        return this.host;
    }

    public AgentHBReq setHost(HostAddr host) {
        this.host = host;
        return this;
    }

    public void unsetHost() {
        this.host = null;
    }

    public boolean isSetHost() {
        return this.host != null;
    }

    public void setHostIsSet(boolean __value) {
        if (!__value) {
            this.host = null;
        }
    }

    public byte[] getGit_info_sha() {
        return this.git_info_sha;
    }

    public AgentHBReq setGit_info_sha(byte[] git_info_sha) {
        this.git_info_sha = git_info_sha;
        return this;
    }

    public void unsetGit_info_sha() {
        this.git_info_sha = null;
    }

    public boolean isSetGit_info_sha() {
        return this.git_info_sha != null;
    }

    public void setGit_info_shaIsSet(boolean __value) {
        if (!__value) {
            this.git_info_sha = null;
        }
    }

    public byte[] getVersion() {
        return this.version;
    }

    public AgentHBReq setVersion(byte[] version) {
        this.version = version;
        return this;
    }

    public void unsetVersion() {
        this.version = null;
    }

    public boolean isSetVersion() {
        return this.version != null;
    }

    public void setVersionIsSet(boolean __value) {
        if (!__value) {
            this.version = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetHost();
                    break;
                }
                this.setHost((HostAddr)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetGit_info_sha();
                    break;
                }
                this.setGit_info_sha((byte[])__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getHost();
            }
            case 2: {
                return this.getGit_info_sha();
            }
            case 3: {
                return this.getVersion();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof AgentHBReq)) {
            return false;
        }
        AgentHBReq that = (AgentHBReq)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetHost(), that.isSetHost(), this.host, that.host)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetGit_info_sha(), that.isSetGit_info_sha(), this.git_info_sha, that.git_info_sha)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetVersion(), that.isSetVersion(), this.version, that.version);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.host, this.git_info_sha, this.version});
    }

    @Override
    public int compareTo(AgentHBReq other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetHost()).compareTo(other.isSetHost());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.host, other.host);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGit_info_sha()).compareTo(other.isSetGit_info_sha());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.git_info_sha, other.git_info_sha);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetVersion()).compareTo(other.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.version, other.version);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 12) {
                        this.host = new HostAddr();
                        this.host.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 11) {
                        this.git_info_sha = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 11) {
                        this.version = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.host != null) {
            oprot.writeFieldBegin(HOST_FIELD_DESC);
            this.host.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.git_info_sha != null) {
            oprot.writeFieldBegin(GIT_INFO_SHA_FIELD_DESC);
            oprot.writeBinary(this.git_info_sha);
            oprot.writeFieldEnd();
        }
        if (this.version != null && this.isSetVersion()) {
            oprot.writeFieldBegin(VERSION_FIELD_DESC);
            oprot.writeBinary(this.version);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("AgentHBReq");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("host");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHost() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHost(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("git_info_sha");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getGit_info_sha() == null) {
            sb.append("null");
        } else {
            int __git_info_sha_size = Math.min(this.getGit_info_sha().length, 128);
            for (i = 0; i < __git_info_sha_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getGit_info_sha()[i]).length() > 1 ? Integer.toHexString(this.getGit_info_sha()[i]).substring(Integer.toHexString(this.getGit_info_sha()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getGit_info_sha()[i]).toUpperCase());
            }
            if (this.getGit_info_sha().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (this.isSetVersion()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("version");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getVersion() == null) {
                sb.append("null");
            } else {
                int __version_size = Math.min(this.getVersion().length, 128);
                for (i = 0; i < __version_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getVersion()[i]).length() > 1 ? Integer.toHexString(this.getVersion()[i]).substring(Integer.toHexString(this.getVersion()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getVersion()[i]).toUpperCase());
                }
                if (this.getVersion().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("host", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("git_info_sha", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(3, new FieldMetaData("version", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(AgentHBReq.class, metaDataMap);
    }

    public static class Builder {
        private HostAddr host;
        private byte[] git_info_sha;
        private byte[] version;

        public Builder setHost(HostAddr host) {
            this.host = host;
            return this;
        }

        public Builder setGit_info_sha(byte[] git_info_sha) {
            this.git_info_sha = git_info_sha;
            return this;
        }

        public Builder setVersion(byte[] version) {
            this.version = version;
            return this;
        }

        public AgentHBReq build() {
            AgentHBReq result = new AgentHBReq();
            result.setHost(this.host);
            result.setGit_info_sha(this.git_info_sha);
            result.setVersion(this.version);
            return result;
        }
    }
}

