/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.meta;

import com.vesoft.nebula.HostAddr;
import com.vesoft.nebula.meta.HostRole;
import com.vesoft.nebula.meta.HostStatus;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldValueMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.ListMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.MapMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.StructMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TList;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TMap;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolUtil;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public class HostItem
implements TBase,
Serializable,
Cloneable,
Comparable<HostItem> {
    private static final TStruct STRUCT_DESC = new TStruct("HostItem");
    private static final TField HOST_ADDR_FIELD_DESC = new TField("hostAddr", 12, 1);
    private static final TField STATUS_FIELD_DESC = new TField("status", 8, 2);
    private static final TField LEADER_PARTS_FIELD_DESC = new TField("leader_parts", 13, 3);
    private static final TField ALL_PARTS_FIELD_DESC = new TField("all_parts", 13, 4);
    private static final TField ROLE_FIELD_DESC = new TField("role", 8, 5);
    private static final TField GIT_INFO_SHA_FIELD_DESC = new TField("git_info_sha", 11, 6);
    private static final TField ZONE_NAME_FIELD_DESC = new TField("zone_name", 11, 7);
    private static final TField VERSION_FIELD_DESC = new TField("version", 11, 8);
    public HostAddr hostAddr;
    public HostStatus status;
    public Map<byte[], List<Integer>> leader_parts;
    public Map<byte[], List<Integer>> all_parts;
    public HostRole role;
    public byte[] git_info_sha;
    public byte[] zone_name;
    public byte[] version;
    public static final int HOSTADDR = 1;
    public static final int STATUS = 2;
    public static final int LEADER_PARTS = 3;
    public static final int ALL_PARTS = 4;
    public static final int ROLE = 5;
    public static final int GIT_INFO_SHA = 6;
    public static final int ZONE_NAME = 7;
    public static final int VERSION = 8;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public HostItem() {
    }

    public HostItem(HostAddr hostAddr, HostStatus status, Map<byte[], List<Integer>> leader_parts, Map<byte[], List<Integer>> all_parts, HostRole role, byte[] git_info_sha) {
        this();
        this.hostAddr = hostAddr;
        this.status = status;
        this.leader_parts = leader_parts;
        this.all_parts = all_parts;
        this.role = role;
        this.git_info_sha = git_info_sha;
    }

    public HostItem(HostAddr hostAddr, HostStatus status, Map<byte[], List<Integer>> leader_parts, Map<byte[], List<Integer>> all_parts, HostRole role, byte[] git_info_sha, byte[] zone_name, byte[] version) {
        this();
        this.hostAddr = hostAddr;
        this.status = status;
        this.leader_parts = leader_parts;
        this.all_parts = all_parts;
        this.role = role;
        this.git_info_sha = git_info_sha;
        this.zone_name = zone_name;
        this.version = version;
    }

    public static Builder builder() {
        return new Builder();
    }

    public HostItem(HostItem other) {
        if (other.isSetHostAddr()) {
            this.hostAddr = TBaseHelper.deepCopy(other.hostAddr);
        }
        if (other.isSetStatus()) {
            this.status = TBaseHelper.deepCopy(other.status);
        }
        if (other.isSetLeader_parts()) {
            this.leader_parts = TBaseHelper.deepCopy(other.leader_parts);
        }
        if (other.isSetAll_parts()) {
            this.all_parts = TBaseHelper.deepCopy(other.all_parts);
        }
        if (other.isSetRole()) {
            this.role = TBaseHelper.deepCopy(other.role);
        }
        if (other.isSetGit_info_sha()) {
            this.git_info_sha = TBaseHelper.deepCopy(other.git_info_sha);
        }
        if (other.isSetZone_name()) {
            this.zone_name = TBaseHelper.deepCopy(other.zone_name);
        }
        if (other.isSetVersion()) {
            this.version = TBaseHelper.deepCopy(other.version);
        }
    }

    @Override
    public HostItem deepCopy() {
        return new HostItem(this);
    }

    public HostAddr getHostAddr() {
        return this.hostAddr;
    }

    public HostItem setHostAddr(HostAddr hostAddr) {
        this.hostAddr = hostAddr;
        return this;
    }

    public void unsetHostAddr() {
        this.hostAddr = null;
    }

    public boolean isSetHostAddr() {
        return this.hostAddr != null;
    }

    public void setHostAddrIsSet(boolean __value) {
        if (!__value) {
            this.hostAddr = null;
        }
    }

    public HostStatus getStatus() {
        return this.status;
    }

    public HostItem setStatus(HostStatus status) {
        this.status = status;
        return this;
    }

    public void unsetStatus() {
        this.status = null;
    }

    public boolean isSetStatus() {
        return this.status != null;
    }

    public void setStatusIsSet(boolean __value) {
        if (!__value) {
            this.status = null;
        }
    }

    public Map<byte[], List<Integer>> getLeader_parts() {
        return this.leader_parts;
    }

    public HostItem setLeader_parts(Map<byte[], List<Integer>> leader_parts) {
        this.leader_parts = leader_parts;
        return this;
    }

    public void unsetLeader_parts() {
        this.leader_parts = null;
    }

    public boolean isSetLeader_parts() {
        return this.leader_parts != null;
    }

    public void setLeader_partsIsSet(boolean __value) {
        if (!__value) {
            this.leader_parts = null;
        }
    }

    public Map<byte[], List<Integer>> getAll_parts() {
        return this.all_parts;
    }

    public HostItem setAll_parts(Map<byte[], List<Integer>> all_parts) {
        this.all_parts = all_parts;
        return this;
    }

    public void unsetAll_parts() {
        this.all_parts = null;
    }

    public boolean isSetAll_parts() {
        return this.all_parts != null;
    }

    public void setAll_partsIsSet(boolean __value) {
        if (!__value) {
            this.all_parts = null;
        }
    }

    public HostRole getRole() {
        return this.role;
    }

    public HostItem setRole(HostRole role) {
        this.role = role;
        return this;
    }

    public void unsetRole() {
        this.role = null;
    }

    public boolean isSetRole() {
        return this.role != null;
    }

    public void setRoleIsSet(boolean __value) {
        if (!__value) {
            this.role = null;
        }
    }

    public byte[] getGit_info_sha() {
        return this.git_info_sha;
    }

    public HostItem setGit_info_sha(byte[] git_info_sha) {
        this.git_info_sha = git_info_sha;
        return this;
    }

    public void unsetGit_info_sha() {
        this.git_info_sha = null;
    }

    public boolean isSetGit_info_sha() {
        return this.git_info_sha != null;
    }

    public void setGit_info_shaIsSet(boolean __value) {
        if (!__value) {
            this.git_info_sha = null;
        }
    }

    public byte[] getZone_name() {
        return this.zone_name;
    }

    public HostItem setZone_name(byte[] zone_name) {
        this.zone_name = zone_name;
        return this;
    }

    public void unsetZone_name() {
        this.zone_name = null;
    }

    public boolean isSetZone_name() {
        return this.zone_name != null;
    }

    public void setZone_nameIsSet(boolean __value) {
        if (!__value) {
            this.zone_name = null;
        }
    }

    public byte[] getVersion() {
        return this.version;
    }

    public HostItem setVersion(byte[] version) {
        this.version = version;
        return this;
    }

    public void unsetVersion() {
        this.version = null;
    }

    public boolean isSetVersion() {
        return this.version != null;
    }

    public void setVersionIsSet(boolean __value) {
        if (!__value) {
            this.version = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetHostAddr();
                    break;
                }
                this.setHostAddr((HostAddr)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetStatus();
                    break;
                }
                this.setStatus((HostStatus)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetLeader_parts();
                    break;
                }
                this.setLeader_parts((Map)__value);
                break;
            }
            case 4: {
                if (__value == null) {
                    this.unsetAll_parts();
                    break;
                }
                this.setAll_parts((Map)__value);
                break;
            }
            case 5: {
                if (__value == null) {
                    this.unsetRole();
                    break;
                }
                this.setRole((HostRole)__value);
                break;
            }
            case 6: {
                if (__value == null) {
                    this.unsetGit_info_sha();
                    break;
                }
                this.setGit_info_sha((byte[])__value);
                break;
            }
            case 7: {
                if (__value == null) {
                    this.unsetZone_name();
                    break;
                }
                this.setZone_name((byte[])__value);
                break;
            }
            case 8: {
                if (__value == null) {
                    this.unsetVersion();
                    break;
                }
                this.setVersion((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getHostAddr();
            }
            case 2: {
                return this.getStatus();
            }
            case 3: {
                return this.getLeader_parts();
            }
            case 4: {
                return this.getAll_parts();
            }
            case 5: {
                return this.getRole();
            }
            case 6: {
                return this.getGit_info_sha();
            }
            case 7: {
                return this.getZone_name();
            }
            case 8: {
                return this.getVersion();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof HostItem)) {
            return false;
        }
        HostItem that = (HostItem)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetHostAddr(), that.isSetHostAddr(), this.hostAddr, that.hostAddr)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetStatus(), that.isSetStatus(), this.status, that.status)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetLeader_parts(), that.isSetLeader_parts(), this.leader_parts, that.leader_parts)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetAll_parts(), that.isSetAll_parts(), this.all_parts, that.all_parts)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetRole(), that.isSetRole(), this.role, that.role)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetGit_info_sha(), that.isSetGit_info_sha(), this.git_info_sha, that.git_info_sha)) {
            return false;
        }
        if (!TBaseHelper.equalsSlow(this.isSetZone_name(), that.isSetZone_name(), this.zone_name, that.zone_name)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetVersion(), that.isSetVersion(), this.version, that.version);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.hostAddr, this.status, this.leader_parts, this.all_parts, this.role, this.git_info_sha, this.zone_name, this.version});
    }

    @Override
    public int compareTo(HostItem other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetHostAddr()).compareTo(other.isSetHostAddr());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.hostAddr, other.hostAddr);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetStatus()).compareTo(other.isSetStatus());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.status, other.status);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetLeader_parts()).compareTo(other.isSetLeader_parts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.leader_parts, other.leader_parts);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetAll_parts()).compareTo(other.isSetAll_parts());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.all_parts, other.all_parts);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetRole()).compareTo(other.isSetRole());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.role, other.role);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetGit_info_sha()).compareTo(other.isSetGit_info_sha());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.git_info_sha, other.git_info_sha);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetZone_name()).compareTo(other.isSetZone_name());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.zone_name, other.zone_name);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetVersion()).compareTo(other.isSetVersion());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.version, other.version);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 12) {
                        this.hostAddr = new HostAddr();
                        this.hostAddr.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 8) {
                        this.status = HostStatus.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 13) {
                        TMap _map12 = iprot.readMapBegin();
                        this.leader_parts = new HashMap<byte[], List<Integer>>(Math.max(0, 2 * _map12.size));
                        int _i13 = 0;
                        while (_map12.size < 0 ? iprot.peekMap() : _i13 < _map12.size) {
                            byte[] _key14 = iprot.readBinary();
                            TList _list16 = iprot.readListBegin();
                            ArrayList<Integer> _val15 = new ArrayList<Integer>(Math.max(0, _list16.size));
                            int _i17 = 0;
                            while (_list16.size < 0 ? iprot.peekList() : _i17 < _list16.size) {
                                int _elem18 = iprot.readI32();
                                _val15.add(_elem18);
                                ++_i17;
                            }
                            iprot.readListEnd();
                            this.leader_parts.put(_key14, _val15);
                            ++_i13;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 4: {
                    if (__field.type == 13) {
                        TMap _map19 = iprot.readMapBegin();
                        this.all_parts = new HashMap<byte[], List<Integer>>(Math.max(0, 2 * _map19.size));
                        int _i20 = 0;
                        while (_map19.size < 0 ? iprot.peekMap() : _i20 < _map19.size) {
                            byte[] _key21 = iprot.readBinary();
                            TList _list23 = iprot.readListBegin();
                            ArrayList<Integer> _val22 = new ArrayList<Integer>(Math.max(0, _list23.size));
                            int _i24 = 0;
                            while (_list23.size < 0 ? iprot.peekList() : _i24 < _list23.size) {
                                int _elem25 = iprot.readI32();
                                _val22.add(_elem25);
                                ++_i24;
                            }
                            iprot.readListEnd();
                            this.all_parts.put(_key21, _val22);
                            ++_i20;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 5: {
                    if (__field.type == 8) {
                        this.role = HostRole.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 6: {
                    if (__field.type == 11) {
                        this.git_info_sha = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 7: {
                    if (__field.type == 11) {
                        this.zone_name = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 8: {
                    if (__field.type == 11) {
                        this.version = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.hostAddr != null) {
            oprot.writeFieldBegin(HOST_ADDR_FIELD_DESC);
            this.hostAddr.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.status != null) {
            oprot.writeFieldBegin(STATUS_FIELD_DESC);
            oprot.writeI32(this.status == null ? 0 : this.status.getValue());
            oprot.writeFieldEnd();
        }
        if (this.leader_parts != null) {
            oprot.writeFieldBegin(LEADER_PARTS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 15, this.leader_parts.size()));
            for (Map.Entry<byte[], List<Integer>> _iter26 : this.leader_parts.entrySet()) {
                oprot.writeBinary(_iter26.getKey());
                oprot.writeListBegin(new TList(8, _iter26.getValue().size()));
                for (int _iter27 : _iter26.getValue()) {
                    oprot.writeI32(_iter27);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.all_parts != null) {
            oprot.writeFieldBegin(ALL_PARTS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(11, 15, this.all_parts.size()));
            for (Map.Entry<byte[], List<Integer>> _iter28 : this.all_parts.entrySet()) {
                oprot.writeBinary(_iter28.getKey());
                oprot.writeListBegin(new TList(8, _iter28.getValue().size()));
                for (int _iter29 : _iter28.getValue()) {
                    oprot.writeI32(_iter29);
                }
                oprot.writeListEnd();
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        if (this.role != null) {
            oprot.writeFieldBegin(ROLE_FIELD_DESC);
            oprot.writeI32(this.role == null ? 0 : this.role.getValue());
            oprot.writeFieldEnd();
        }
        if (this.git_info_sha != null) {
            oprot.writeFieldBegin(GIT_INFO_SHA_FIELD_DESC);
            oprot.writeBinary(this.git_info_sha);
            oprot.writeFieldEnd();
        }
        if (this.zone_name != null && this.isSetZone_name()) {
            oprot.writeFieldBegin(ZONE_NAME_FIELD_DESC);
            oprot.writeBinary(this.zone_name);
            oprot.writeFieldEnd();
        }
        if (this.version != null && this.isSetVersion()) {
            oprot.writeFieldBegin(VERSION_FIELD_DESC);
            oprot.writeBinary(this.version);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("HostItem");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("hostAddr");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getHostAddr() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getHostAddr(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("status");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getStatus() == null) {
            sb.append("null");
        } else {
            String status_name;
            String string = status_name = this.getStatus() == null ? "null" : this.getStatus().name();
            if (status_name != null) {
                sb.append(status_name);
                sb.append(" (");
            }
            sb.append(this.getStatus());
            if (status_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("leader_parts");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getLeader_parts() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getLeader_parts(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("all_parts");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getAll_parts() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getAll_parts(), indent + 1, prettyPrint));
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("role");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getRole() == null) {
            sb.append("null");
        } else {
            String role_name;
            String string = role_name = this.getRole() == null ? "null" : this.getRole().name();
            if (role_name != null) {
                sb.append(role_name);
                sb.append(" (");
            }
            sb.append(this.getRole());
            if (role_name != null) {
                sb.append(")");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("git_info_sha");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getGit_info_sha() == null) {
            sb.append("null");
        } else {
            int __git_info_sha_size = Math.min(this.getGit_info_sha().length, 128);
            for (i = 0; i < __git_info_sha_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getGit_info_sha()[i]).length() > 1 ? Integer.toHexString(this.getGit_info_sha()[i]).substring(Integer.toHexString(this.getGit_info_sha()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getGit_info_sha()[i]).toUpperCase());
            }
            if (this.getGit_info_sha().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (this.isSetZone_name()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("zone_name");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getZone_name() == null) {
                sb.append("null");
            } else {
                int __zone_name_size = Math.min(this.getZone_name().length, 128);
                for (i = 0; i < __zone_name_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getZone_name()[i]).length() > 1 ? Integer.toHexString(this.getZone_name()[i]).substring(Integer.toHexString(this.getZone_name()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getZone_name()[i]).toUpperCase());
                }
                if (this.getZone_name().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        if (this.isSetVersion()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("version");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getVersion() == null) {
                sb.append("null");
            } else {
                int __version_size = Math.min(this.getVersion().length, 128);
                for (i = 0; i < __version_size; ++i) {
                    if (i != 0) {
                        sb.append(" ");
                    }
                    sb.append(Integer.toHexString(this.getVersion()[i]).length() > 1 ? Integer.toHexString(this.getVersion()[i]).substring(Integer.toHexString(this.getVersion()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getVersion()[i]).toUpperCase());
                }
                if (this.getVersion().length > 128) {
                    sb.append(" ...");
                }
            }
            first = false;
        }
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("hostAddr", 3, new StructMetaData(12, HostAddr.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("status", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(3, new FieldMetaData("leader_parts", 3, new MapMetaData(13, new FieldValueMetaData(11), new ListMetaData(15, new FieldValueMetaData(8)))));
        tmpMetaDataMap.put(4, new FieldMetaData("all_parts", 3, new MapMetaData(13, new FieldValueMetaData(11), new ListMetaData(15, new FieldValueMetaData(8)))));
        tmpMetaDataMap.put(5, new FieldMetaData("role", 3, new FieldValueMetaData(8)));
        tmpMetaDataMap.put(6, new FieldMetaData("git_info_sha", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(7, new FieldMetaData("zone_name", 2, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(8, new FieldMetaData("version", 2, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(HostItem.class, metaDataMap);
    }

    public static class Builder {
        private HostAddr hostAddr;
        private HostStatus status;
        private Map<byte[], List<Integer>> leader_parts;
        private Map<byte[], List<Integer>> all_parts;
        private HostRole role;
        private byte[] git_info_sha;
        private byte[] zone_name;
        private byte[] version;

        public Builder setHostAddr(HostAddr hostAddr) {
            this.hostAddr = hostAddr;
            return this;
        }

        public Builder setStatus(HostStatus status) {
            this.status = status;
            return this;
        }

        public Builder setLeader_parts(Map<byte[], List<Integer>> leader_parts) {
            this.leader_parts = leader_parts;
            return this;
        }

        public Builder setAll_parts(Map<byte[], List<Integer>> all_parts) {
            this.all_parts = all_parts;
            return this;
        }

        public Builder setRole(HostRole role) {
            this.role = role;
            return this;
        }

        public Builder setGit_info_sha(byte[] git_info_sha) {
            this.git_info_sha = git_info_sha;
            return this;
        }

        public Builder setZone_name(byte[] zone_name) {
            this.zone_name = zone_name;
            return this;
        }

        public Builder setVersion(byte[] version) {
            this.version = version;
            return this;
        }

        public HostItem build() {
            HostItem result = new HostItem();
            result.setHostAddr(this.hostAddr);
            result.setStatus(this.status);
            result.setLeader_parts(this.leader_parts);
            result.setAll_parts(this.all_parts);
            result.setRole(this.role);
            result.setGit_info_sha(this.git_info_sha);
            result.setZone_name(this.zone_name);
            result.setVersion(this.version);
            return result;
        }
    }
}

