/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldValueMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolUtil;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public class Expr
implements TBase,
Serializable,
Cloneable,
Comparable<Expr> {
    private static final TStruct STRUCT_DESC = new TStruct("Expr");
    private static final TField ALIAS_FIELD_DESC = new TField("alias", 11, 1);
    private static final TField EXPR_FIELD_DESC = new TField("expr", 11, 2);
    public byte[] alias;
    public byte[] expr;
    public static final int ALIAS = 1;
    public static final int EXPR = 2;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public Expr() {
    }

    public Expr(byte[] alias, byte[] expr) {
        this();
        this.alias = alias;
        this.expr = expr;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Expr(Expr other) {
        if (other.isSetAlias()) {
            this.alias = TBaseHelper.deepCopy(other.alias);
        }
        if (other.isSetExpr()) {
            this.expr = TBaseHelper.deepCopy(other.expr);
        }
    }

    @Override
    public Expr deepCopy() {
        return new Expr(this);
    }

    public byte[] getAlias() {
        return this.alias;
    }

    public Expr setAlias(byte[] alias) {
        this.alias = alias;
        return this;
    }

    public void unsetAlias() {
        this.alias = null;
    }

    public boolean isSetAlias() {
        return this.alias != null;
    }

    public void setAliasIsSet(boolean __value) {
        if (!__value) {
            this.alias = null;
        }
    }

    public byte[] getExpr() {
        return this.expr;
    }

    public Expr setExpr(byte[] expr) {
        this.expr = expr;
        return this;
    }

    public void unsetExpr() {
        this.expr = null;
    }

    public boolean isSetExpr() {
        return this.expr != null;
    }

    public void setExprIsSet(boolean __value) {
        if (!__value) {
            this.expr = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetAlias();
                    break;
                }
                this.setAlias((byte[])__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetExpr();
                    break;
                }
                this.setExpr((byte[])__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getAlias();
            }
            case 2: {
                return this.getExpr();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof Expr)) {
            return false;
        }
        Expr that = (Expr)_that;
        if (!TBaseHelper.equalsSlow(this.isSetAlias(), that.isSetAlias(), this.alias, that.alias)) {
            return false;
        }
        return TBaseHelper.equalsSlow(this.isSetExpr(), that.isSetExpr(), this.expr, that.expr);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.alias, this.expr});
    }

    @Override
    public int compareTo(Expr other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = 0;
        lastComparison = Boolean.valueOf(this.isSetAlias()).compareTo(other.isSetAlias());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.alias, other.alias);
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetExpr()).compareTo(other.isSetExpr());
        if (lastComparison != 0) {
            return lastComparison;
        }
        lastComparison = TBaseHelper.compareTo(this.expr, other.expr);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return 0;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 11) {
                        this.alias = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 11) {
                        this.expr = iprot.readBinary();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.alias != null) {
            oprot.writeFieldBegin(ALIAS_FIELD_DESC);
            oprot.writeBinary(this.alias);
            oprot.writeFieldEnd();
        }
        if (this.expr != null) {
            oprot.writeFieldBegin(EXPR_FIELD_DESC);
            oprot.writeBinary(this.expr);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int i;
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("Expr");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("alias");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getAlias() == null) {
            sb.append("null");
        } else {
            int __alias_size = Math.min(this.getAlias().length, 128);
            for (i = 0; i < __alias_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getAlias()[i]).length() > 1 ? Integer.toHexString(this.getAlias()[i]).substring(Integer.toHexString(this.getAlias()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getAlias()[i]).toUpperCase());
            }
            if (this.getAlias().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("expr");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getExpr() == null) {
            sb.append("null");
        } else {
            int __expr_size = Math.min(this.getExpr().length, 128);
            for (i = 0; i < __expr_size; ++i) {
                if (i != 0) {
                    sb.append(" ");
                }
                sb.append(Integer.toHexString(this.getExpr()[i]).length() > 1 ? Integer.toHexString(this.getExpr()[i]).substring(Integer.toHexString(this.getExpr()[i]).length() - 2).toUpperCase() : "0" + Integer.toHexString(this.getExpr()[i]).toUpperCase());
            }
            if (this.getExpr().length > 128) {
                sb.append(" ...");
            }
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("alias", 3, new FieldValueMetaData(11)));
        tmpMetaDataMap.put(2, new FieldMetaData("expr", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(Expr.class, metaDataMap);
    }

    public static class Builder {
        private byte[] alias;
        private byte[] expr;

        public Builder setAlias(byte[] alias) {
            this.alias = alias;
            return this;
        }

        public Builder setExpr(byte[] expr) {
            this.expr = expr;
            return this;
        }

        public Expr build() {
            Expr result = new Expr();
            result.setAlias(this.alias);
            result.setExpr(this.expr);
            return result;
        }
    }
}

