/*
 * Decompiled with CFR 0.152.
 */
package com.vesoft.nebula.storage;

import com.vesoft.nebula.DataSet;
import com.vesoft.nebula.storage.ResponseCommon;
import com.vesoft.nebula.storage.ScanCursor;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldValueMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.MapMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.StructMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TMap;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolUtil;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public class ScanResponse
implements TBase,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("ScanResponse");
    private static final TField RESULT_FIELD_DESC = new TField("result", 12, 1);
    private static final TField PROPS_FIELD_DESC = new TField("props", 12, 2);
    private static final TField CURSORS_FIELD_DESC = new TField("cursors", 13, 3);
    public ResponseCommon result;
    public DataSet props;
    public Map<Integer, ScanCursor> cursors;
    public static final int RESULT = 1;
    public static final int PROPS = 2;
    public static final int CURSORS = 3;
    public static final Map<Integer, FieldMetaData> metaDataMap;

    public ScanResponse() {
    }

    public ScanResponse(ResponseCommon result) {
        this();
        this.result = result;
    }

    public ScanResponse(ResponseCommon result, Map<Integer, ScanCursor> cursors) {
        this();
        this.result = result;
        this.cursors = cursors;
    }

    public ScanResponse(ResponseCommon result, DataSet props, Map<Integer, ScanCursor> cursors) {
        this();
        this.result = result;
        this.props = props;
        this.cursors = cursors;
    }

    public static Builder builder() {
        return new Builder();
    }

    public ScanResponse(ScanResponse other) {
        if (other.isSetResult()) {
            this.result = TBaseHelper.deepCopy(other.result);
        }
        if (other.isSetProps()) {
            this.props = TBaseHelper.deepCopy(other.props);
        }
        if (other.isSetCursors()) {
            this.cursors = TBaseHelper.deepCopy(other.cursors);
        }
    }

    @Override
    public ScanResponse deepCopy() {
        return new ScanResponse(this);
    }

    public ResponseCommon getResult() {
        return this.result;
    }

    public ScanResponse setResult(ResponseCommon result) {
        this.result = result;
        return this;
    }

    public void unsetResult() {
        this.result = null;
    }

    public boolean isSetResult() {
        return this.result != null;
    }

    public void setResultIsSet(boolean __value) {
        if (!__value) {
            this.result = null;
        }
    }

    public DataSet getProps() {
        return this.props;
    }

    public ScanResponse setProps(DataSet props) {
        this.props = props;
        return this;
    }

    public void unsetProps() {
        this.props = null;
    }

    public boolean isSetProps() {
        return this.props != null;
    }

    public void setPropsIsSet(boolean __value) {
        if (!__value) {
            this.props = null;
        }
    }

    public Map<Integer, ScanCursor> getCursors() {
        return this.cursors;
    }

    public ScanResponse setCursors(Map<Integer, ScanCursor> cursors) {
        this.cursors = cursors;
        return this;
    }

    public void unsetCursors() {
        this.cursors = null;
    }

    public boolean isSetCursors() {
        return this.cursors != null;
    }

    public void setCursorsIsSet(boolean __value) {
        if (!__value) {
            this.cursors = null;
        }
    }

    public void setFieldValue(int fieldID, Object __value) {
        switch (fieldID) {
            case 1: {
                if (__value == null) {
                    this.unsetResult();
                    break;
                }
                this.setResult((ResponseCommon)__value);
                break;
            }
            case 2: {
                if (__value == null) {
                    this.unsetProps();
                    break;
                }
                this.setProps((DataSet)__value);
                break;
            }
            case 3: {
                if (__value == null) {
                    this.unsetCursors();
                    break;
                }
                this.setCursors((Map)__value);
                break;
            }
            default: {
                throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
            }
        }
    }

    public Object getFieldValue(int fieldID) {
        switch (fieldID) {
            case 1: {
                return this.getResult();
            }
            case 2: {
                return this.getProps();
            }
            case 3: {
                return this.getCursors();
            }
        }
        throw new IllegalArgumentException("Field " + fieldID + " doesn't exist!");
    }

    public boolean equals(Object _that) {
        if (_that == null) {
            return false;
        }
        if (this == _that) {
            return true;
        }
        if (!(_that instanceof ScanResponse)) {
            return false;
        }
        ScanResponse that = (ScanResponse)_that;
        if (!TBaseHelper.equalsNobinary(this.isSetResult(), that.isSetResult(), this.result, that.result)) {
            return false;
        }
        if (!TBaseHelper.equalsNobinary(this.isSetProps(), that.isSetProps(), this.props, that.props)) {
            return false;
        }
        return TBaseHelper.equalsNobinary(this.isSetCursors(), that.isSetCursors(), this.cursors, that.cursors);
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.result, this.props, this.cursors});
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin(metaDataMap);
        while (true) {
            TField __field = iprot.readFieldBegin();
            if (__field.type == 0) break;
            switch (__field.id) {
                case 1: {
                    if (__field.type == 12) {
                        this.result = new ResponseCommon();
                        this.result.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 2: {
                    if (__field.type == 12) {
                        this.props = new DataSet();
                        this.props.read(iprot);
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                case 3: {
                    if (__field.type == 13) {
                        TMap _map228 = iprot.readMapBegin();
                        this.cursors = new HashMap<Integer, ScanCursor>(Math.max(0, 2 * _map228.size));
                        int _i229 = 0;
                        while (_map228.size < 0 ? iprot.peekMap() : _i229 < _map228.size) {
                            int _key230 = iprot.readI32();
                            ScanCursor _val231 = new ScanCursor();
                            _val231.read(iprot);
                            this.cursors.put(_key230, _val231);
                            ++_i229;
                        }
                        iprot.readMapEnd();
                        break;
                    }
                    TProtocolUtil.skip(iprot, __field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip(iprot, __field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.result != null) {
            oprot.writeFieldBegin(RESULT_FIELD_DESC);
            this.result.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.props != null && this.isSetProps()) {
            oprot.writeFieldBegin(PROPS_FIELD_DESC);
            this.props.write(oprot);
            oprot.writeFieldEnd();
        }
        if (this.cursors != null) {
            oprot.writeFieldBegin(CURSORS_FIELD_DESC);
            oprot.writeMapBegin(new TMap(8, 12, this.cursors.size()));
            for (Map.Entry<Integer, ScanCursor> _iter232 : this.cursors.entrySet()) {
                oprot.writeI32(_iter232.getKey());
                _iter232.getValue().write(oprot);
            }
            oprot.writeMapEnd();
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        return this.toString(1, true);
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        String indentStr = prettyPrint ? TBaseHelper.getIndentedString(indent) : "";
        String newLine = prettyPrint ? "\n" : "";
        String space = prettyPrint ? " " : "";
        StringBuilder sb = new StringBuilder("ScanResponse");
        sb.append(space);
        sb.append("(");
        sb.append(newLine);
        boolean first = true;
        sb.append(indentStr);
        sb.append("result");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getResult() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getResult(), indent + 1, prettyPrint));
        }
        first = false;
        if (this.isSetProps()) {
            if (!first) {
                sb.append("," + newLine);
            }
            sb.append(indentStr);
            sb.append("props");
            sb.append(space);
            sb.append(":").append(space);
            if (this.getProps() == null) {
                sb.append("null");
            } else {
                sb.append(TBaseHelper.toString(this.getProps(), indent + 1, prettyPrint));
            }
            first = false;
        }
        if (!first) {
            sb.append("," + newLine);
        }
        sb.append(indentStr);
        sb.append("cursors");
        sb.append(space);
        sb.append(":").append(space);
        if (this.getCursors() == null) {
            sb.append("null");
        } else {
            sb.append(TBaseHelper.toString(this.getCursors(), indent + 1, prettyPrint));
        }
        first = false;
        sb.append(newLine + TBaseHelper.reduceIndent(indentStr));
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
        if (this.result == null) {
            throw new TProtocolException(6, "Required field 'result' was not present! Struct: " + this.toString());
        }
    }

    static {
        HashMap<Integer, FieldMetaData> tmpMetaDataMap = new HashMap<Integer, FieldMetaData>();
        tmpMetaDataMap.put(1, new FieldMetaData("result", 1, new StructMetaData(12, ResponseCommon.class)));
        tmpMetaDataMap.put(2, new FieldMetaData("props", 2, new StructMetaData(12, DataSet.class)));
        tmpMetaDataMap.put(3, new FieldMetaData("cursors", 3, new MapMetaData(13, new FieldValueMetaData(8), new StructMetaData(12, ScanCursor.class))));
        metaDataMap = Collections.unmodifiableMap(tmpMetaDataMap);
        FieldMetaData.addStructMetaDataMap(ScanResponse.class, metaDataMap);
    }

    public static class Builder {
        private ResponseCommon result;
        private DataSet props;
        private Map<Integer, ScanCursor> cursors;

        public Builder setResult(ResponseCommon result) {
            this.result = result;
            return this;
        }

        public Builder setProps(DataSet props) {
            this.props = props;
            return this;
        }

        public Builder setCursors(Map<Integer, ScanCursor> cursors) {
            this.cursors = cursors;
            return this;
        }

        public ScanResponse build() {
            ScanResponse result = new ScanResponse();
            result.setResult(this.result);
            result.setProps(this.props);
            result.setCursors(this.cursors);
            return result;
        }
    }
}

