/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.catalog;

import com.vesoft.nebula.client.graph.data.HostAddress;
import com.vesoft.nebula.client.graph.exception.ClientServerIncompatibleException;
import com.vesoft.nebula.client.meta.MetaClient;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.org.slf4j.Logger;
import org.apache.flink.connector.nebula.shaded.org.slf4j.LoggerFactory;
import org.apache.flink.connector.nebula.table.NebulaDynamicTableFactory;
import org.apache.flink.connector.nebula.utils.NebulaUtils;
import org.apache.flink.table.api.ValidationException;
import org.apache.flink.table.catalog.AbstractCatalog;
import org.apache.flink.table.catalog.CatalogBaseTable;
import org.apache.flink.table.catalog.CatalogDatabase;
import org.apache.flink.table.catalog.CatalogFunction;
import org.apache.flink.table.catalog.CatalogPartition;
import org.apache.flink.table.catalog.CatalogPartitionSpec;
import org.apache.flink.table.catalog.ObjectPath;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.catalog.exceptions.FunctionNotExistException;
import org.apache.flink.table.catalog.stats.CatalogColumnStatistics;
import org.apache.flink.table.catalog.stats.CatalogTableStatistics;
import org.apache.flink.table.expressions.Expression;
import org.apache.flink.table.factories.Factory;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

public abstract class AbstractNebulaCatalog
extends AbstractCatalog {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractNebulaCatalog.class);
    protected final String username;
    protected final String password;
    protected final String address;
    private static final String DEFAULT_DATABASE = "default";

    public AbstractNebulaCatalog(String catalogName, String defaultDatabase, String username, String password, String address) {
        super(catalogName, defaultDatabase == null ? DEFAULT_DATABASE : defaultDatabase);
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)username) ? 1 : 0) != 0, (Object)"username cannot be null or empty.");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)password) ? 1 : 0) != 0, (Object)"password cannot be null or empty.");
        Preconditions.checkArgument((!StringUtils.isNullOrWhitespaceOnly((String)address) ? 1 : 0) != 0, (Object)"address cannot be null or empty.");
        this.username = username;
        this.password = password;
        this.address = address;
    }

    public void open() throws CatalogException {
        List<HostAddress> hostAndPorts = NebulaUtils.getHostAndPorts(this.address);
        MetaClient metaClient = null;
        try {
            metaClient = new MetaClient(hostAndPorts);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("address is illegal, ", e);
        }
        try {
            metaClient.connect();
            metaClient.close();
        }
        catch (ClientServerIncompatibleException | TException e) {
            throw new ValidationException(String.format("Failed connecting to meta service via %s, ", this.address), (Throwable)e);
        }
        LOG.info("Catalog {} established connection to {}", (Object)this.getName(), (Object)this.address);
    }

    public void close() throws CatalogException {
        LOG.info("Catalog {} closing", (Object)this.getName());
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAddress() {
        return this.address;
    }

    public Optional<Factory> getFactory() {
        return Optional.of(new NebulaDynamicTableFactory());
    }

    public boolean databaseExists(String dataBaseName) throws CatalogException {
        return this.listDatabases().contains(dataBaseName);
    }

    public void createDatabase(String dataBaseName, CatalogDatabase catalogDatabase, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropDatabase(String dataBaseName, boolean ignoreIfNotExists) throws CatalogException {
        this.dropDatabase(dataBaseName, ignoreIfNotExists, false);
    }

    public void dropDatabase(String dataBaseName, boolean ignoreIfNotExists, boolean cascade) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterDatabase(String dataBaseName, CatalogDatabase newDatabase, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<String> listViews(String databaseName) throws CatalogException {
        return Collections.emptyList();
    }

    public void dropTable(ObjectPath tablePath, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void renameTable(ObjectPath tablePath, String newTableName, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void createTable(ObjectPath tablePath, CatalogBaseTable table, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTable(ObjectPath tablePath, CatalogBaseTable newTable, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath) throws CatalogException {
        return Collections.emptyList();
    }

    public List<CatalogPartitionSpec> listPartitions(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return Collections.emptyList();
    }

    public List<CatalogPartitionSpec> listPartitionsByFilter(ObjectPath tablePath, List<Expression> filters) throws CatalogException {
        return Collections.emptyList();
    }

    public CatalogPartition getPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public boolean partitionExists(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return false;
    }

    public void createPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition partition, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartition(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogPartition newPartition, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public List<String> listFunctions(String dbName) throws CatalogException {
        return Collections.emptyList();
    }

    public CatalogFunction getFunction(ObjectPath functionPath) throws FunctionNotExistException, CatalogException {
        throw new FunctionNotExistException(this.getName(), functionPath);
    }

    public boolean functionExists(ObjectPath functionPath) throws CatalogException {
        return false;
    }

    public void createFunction(ObjectPath functionPath, CatalogFunction function, boolean ignoreIfExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterFunction(ObjectPath functionPath, CatalogFunction newFunction, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void dropFunction(ObjectPath functionPath, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public CatalogTableStatistics getTableStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getTableColumnStatistics(ObjectPath tablePath) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public CatalogTableStatistics getPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogTableStatistics.UNKNOWN;
    }

    public CatalogColumnStatistics getPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec) throws CatalogException {
        return CatalogColumnStatistics.UNKNOWN;
    }

    public void alterTableStatistics(ObjectPath tablePath, CatalogTableStatistics tableStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterTableColumnStatistics(ObjectPath tablePath, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogTableStatistics partitionStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }

    public void alterPartitionColumnStatistics(ObjectPath tablePath, CatalogPartitionSpec partitionSpec, CatalogColumnStatistics columnStatistics, boolean ignoreIfNotExists) throws CatalogException {
        throw new UnsupportedOperationException();
    }
}

