/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBase;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TBaseHelper;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TEnum;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.meta_data.FieldMetaData;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TField;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TStruct;

public abstract class TUnion<Me extends TUnion<Me>>
implements TBase {
    protected Object value_;
    protected int setField_;

    protected TUnion() {
        this.setField_ = 0;
        this.value_ = null;
    }

    protected TUnion(int fieldId, Object value) {
        this.setFieldValue(fieldId, value);
    }

    protected TUnion(TUnion<Me> other) {
        if (!other.getClass().equals(this.getClass())) {
            throw new ClassCastException();
        }
        this.setField_ = other.setField_;
        this.value_ = TBaseHelper.deepCopyUnchecked(other.value_);
    }

    public int getSetField() {
        return this.setField_;
    }

    public Object getFieldValue() {
        return this.value_;
    }

    public Object getFieldValue(int fieldId) {
        if (fieldId != this.setField_) {
            throw new IllegalArgumentException("Cannot get the value of field " + fieldId + " because union's set field is " + this.setField_);
        }
        return this.getFieldValue();
    }

    public boolean isSet() {
        return this.setField_ != 0;
    }

    public boolean isSet(int fieldId) {
        return this.setField_ == fieldId;
    }

    @Override
    public void read(TProtocol iprot) throws TException {
        this.setField_ = 0;
        this.value_ = null;
        iprot.readStructBegin(this.getMetaDataMap());
        TField field = iprot.readFieldBegin();
        if (field.type != 0) {
            this.value_ = this.readValue(iprot, field);
            if (this.value_ != null) {
                this.setField_ = field.id;
            }
            iprot.readFieldEnd();
            iprot.readFieldBegin();
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
    }

    public void setFieldValue(int fieldId, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("TUnion value for field id '%d' can't be null!", fieldId));
        }
        this.checkType((short)fieldId, value);
        this.setField_ = (short)fieldId;
        this.value_ = value;
    }

    @Override
    public void write(TProtocol oprot) throws TException {
        if (this.getSetField() == 0 || this.getFieldValue() == null) {
            throw new TProtocolException("Cannot write a TUnion with no set value!");
        }
        oprot.writeStructBegin(this.getStructDesc());
        oprot.writeFieldBegin(this.getFieldDesc(this.setField_));
        this.writeValue(oprot, (short)this.setField_, this.value_);
        oprot.writeFieldEnd();
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    protected void checkType(short fieldId, Object value) throws ClassCastException, IllegalArgumentException {
        TField tField = TBaseHelper.getTField(this, fieldId);
        if (tField == null) {
            throw new IllegalArgumentException("field #" + fieldId + " not found in Thrift struct " + this.getClass().getSimpleName());
        }
        if (!TUnion.validateType(value, tField.type)) {
            throw new ClassCastException(String.format("Was expecting value of type id %d for field id %d, but got %s", tField.type, fieldId, value.getClass().getSimpleName()));
        }
    }

    private static boolean validateType(Object value, short typeId) {
        switch (typeId) {
            case 2: {
                return value instanceof Boolean;
            }
            case 3: {
                return value instanceof Byte;
            }
            case 4: {
                return value instanceof Double;
            }
            case 6: {
                return value instanceof Short;
            }
            case 8: {
                return value instanceof Integer;
            }
            case 10: {
                return value instanceof Long;
            }
            case 11: {
                return value instanceof String;
            }
            case 12: {
                return value instanceof TBase;
            }
            case 13: {
                return value instanceof Map;
            }
            case 14: {
                return value instanceof Set;
            }
            case 15: {
                return value instanceof List;
            }
            case 16: {
                return value instanceof TEnum;
            }
            case 19: {
                return value instanceof Float;
            }
        }
        return false;
    }

    protected abstract Object readValue(TProtocol var1, TField var2) throws TException;

    protected abstract void writeValue(TProtocol var1, short var2, Object var3) throws TException;

    protected abstract TStruct getStructDesc();

    protected abstract TField getFieldDesc(int var1);

    public abstract Me deepCopy();

    protected int compareToImpl(Me other) {
        if (other == null) {
            throw new NullPointerException();
        }
        if (other == this) {
            return 0;
        }
        int lastComparison = TBaseHelper.compareTo(this.setField_, ((TUnion)other).setField_);
        if (lastComparison != 0) {
            return lastComparison;
        }
        return TBaseHelper.compareToUnchecked(this.getFieldValue(), ((TUnion)other).getFieldValue());
    }

    protected boolean equalsNobinaryImpl(Me other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getSetField() != ((TUnion)other).getSetField()) {
            return false;
        }
        if (this.getFieldValue() == null || ((TUnion)other).getFieldValue() == null) {
            return this.getFieldValue() == null && ((TUnion)other).getFieldValue() == null;
        }
        return TBaseHelper.equalsNobinaryUnchecked(this.getFieldValue(), ((TUnion)other).getFieldValue());
    }

    protected boolean equalsSlowImpl(Me other) {
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getSetField() != ((TUnion)other).getSetField()) {
            return false;
        }
        if (this.getFieldValue() == null || ((TUnion)other).getFieldValue() == null) {
            return this.getFieldValue() == null && ((TUnion)other).getFieldValue() == null;
        }
        return TBaseHelper.equalsSlowUnchecked(this.getFieldValue(), ((TUnion)other).getFieldValue());
    }

    @Override
    public String toString(int indent, boolean prettyPrint) {
        int fieldId = this.getSetField();
        Object v = this.getFieldValue();
        if (v == null) {
            return String.format("<%s uninitialized>", this.getClass().getSimpleName());
        }
        String vStr = null;
        vStr = v instanceof byte[] ? TUnion.bytesToStr((byte[])v) : (TBase.class.isAssignableFrom(v.getClass()) ? ((TBase)v).toString(indent, prettyPrint) : v.toString());
        return String.format("<%s %s:%s>", this.getClass().getSimpleName(), this.getFieldDesc((int)this.getSetField()).name, vStr);
    }

    public String toString() {
        return this.toString(1, true);
    }

    protected abstract Map<Integer, FieldMetaData> getMetaDataMap();

    private static String bytesToStr(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int size = Math.min(bytes.length, 128);
        for (int i = 0; i < size; ++i) {
            String digit;
            if (i != 0) {
                sb.append(" ");
            }
            sb.append((digit = Integer.toHexString(bytes[i])).length() > 1 ? digit : "0" + digit);
        }
        if (bytes.length > 128) {
            sb.append(" ...");
        }
        return sb.toString();
    }
}

