/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift.server.example;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TProcessor;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.TProcessorFactory;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TBinaryProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.THeaderProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocol;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.protocol.TProtocolFactory;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.server.TRpcConnectionContext;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.server.TServer;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.server.TThreadFactoryImpl;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TServerTransport;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TTransport;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TTransportException;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.transport.TTransportFactory;
import org.apache.flink.connector.nebula.shaded.com.facebook.thrift.utils.Logger;

@Deprecated
public class TThreadPoolServer
extends TServer {
    private static final Logger LOGGER = Logger.getLogger(TThreadPoolServer.class.getName());
    private ExecutorService executorService_;
    private volatile boolean stopped_;
    private Options options_;

    public TThreadPoolServer(TProcessor processor, TServerTransport serverTransport) {
        this(processor, serverTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory());
    }

    public TThreadPoolServer(TProcessorFactory processorFactory, TServerTransport serverTransport) {
        this(processorFactory, serverTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory());
    }

    public TThreadPoolServer(TProcessor processor, TServerTransport serverTransport, TProtocolFactory protocolFactory) {
        this(processor, serverTransport, new TTransportFactory(), new TTransportFactory(), protocolFactory, protocolFactory);
    }

    public TThreadPoolServer(TProcessor processor, TServerTransport serverTransport, TTransportFactory transportFactory, TProtocolFactory protocolFactory) {
        this(processor, serverTransport, transportFactory, transportFactory, protocolFactory, protocolFactory);
    }

    public TThreadPoolServer(TProcessorFactory processorFactory, TServerTransport serverTransport, TTransportFactory transportFactory, TProtocolFactory protocolFactory) {
        this(processorFactory, serverTransport, transportFactory, transportFactory, protocolFactory, protocolFactory);
    }

    public TThreadPoolServer(TProcessor processor, TServerTransport serverTransport, TTransportFactory inputTransportFactory, TTransportFactory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory) {
        this(new TProcessorFactory(processor), serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory);
    }

    public TThreadPoolServer(TProcessorFactory processorFactory, TServerTransport serverTransport, TTransportFactory inputTransportFactory, TTransportFactory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory) {
        super(processorFactory, serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory);
        this.options_ = new Options();
        this.executorService_ = Executors.newCachedThreadPool(new TThreadFactoryImpl("thrift"));
    }

    public TThreadPoolServer(TProcessor processor, TServerTransport serverTransport, TTransportFactory inputTransportFactory, TTransportFactory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory, Options options) {
        this(new TProcessorFactory(processor), serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory, options);
    }

    public TThreadPoolServer(TProcessorFactory processorFactory, TServerTransport serverTransport, TTransportFactory inputTransportFactory, TTransportFactory outputTransportFactory, TProtocolFactory inputProtocolFactory, TProtocolFactory outputProtocolFactory, Options options) {
        super(processorFactory, serverTransport, inputTransportFactory, outputTransportFactory, inputProtocolFactory, outputProtocolFactory);
        if (options.executorService != null) {
            this.executorService_ = options.executorService;
        } else {
            RejectedExecutionHandler rejectedExecutionHandler = null;
            rejectedExecutionHandler = options.rejectedExecutionHandler != null ? options.rejectedExecutionHandler : new ThreadPoolExecutor.AbortPolicy();
            BlockingQueue<Runnable> executorQueue = null;
            executorQueue = options.executorQueue != null ? options.executorQueue : new SynchronousQueue<Runnable>();
            this.executorService_ = new ThreadPoolExecutor(options.minWorkerThreads, options.maxWorkerThreads, 60L, TimeUnit.SECONDS, executorQueue, new TThreadFactoryImpl("thrift"), rejectedExecutionHandler);
        }
        this.options_ = options;
    }

    @Override
    public void serve() {
        long newnow;
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.error("Error occurred during listening.", ttx);
            return;
        }
        this.stopped_ = false;
        while (!this.stopped_) {
            try {
                TTransport client = this.serverTransport_.accept();
                WorkerProcess wp = new WorkerProcess(client);
                try {
                    this.executorService_.execute(wp);
                }
                catch (RejectedExecutionException ree) {
                    LOGGER.warn("Client request was rejected by executor", ree);
                    if (client == null || !client.isOpen()) continue;
                    client.close();
                }
            }
            catch (TTransportException ttx) {
                if (this.stopped_) continue;
                LOGGER.warn("Transport error occurred during acceptance of message.", ttx);
            }
        }
        this.executorService_.shutdown();
        long now = System.currentTimeMillis();
        for (long timeoutMS = this.options_.stopTimeoutUnit.toMillis(this.options_.stopTimeoutVal); timeoutMS >= 0L; timeoutMS -= newnow - now) {
            try {
                this.executorService_.awaitTermination(timeoutMS, TimeUnit.MILLISECONDS);
                break;
            }
            catch (InterruptedException ix) {
                newnow = System.currentTimeMillis();
                now = newnow;
                continue;
            }
        }
    }

    @Override
    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
    }

    private class WorkerProcess
    implements Runnable {
        private TTransport client_;

        private WorkerProcess(TTransport client) {
            this.client_ = client;
        }

        @Override
        public void run() {
            TProcessor processor = null;
            TTransport inputTransport = null;
            TTransport outputTransport = null;
            TProtocol inputProtocol = null;
            TProtocol outputProtocol = null;
            try {
                processor = TThreadPoolServer.this.processorFactory_.getProcessor(this.client_);
                inputTransport = TThreadPoolServer.this.inputTransportFactory_.getTransport(this.client_);
                inputProtocol = TThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                if (inputProtocol instanceof THeaderProtocol) {
                    outputProtocol = inputProtocol;
                } else {
                    outputTransport = TThreadPoolServer.this.outputTransportFactory_.getTransport(this.client_);
                    outputProtocol = TThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                }
                TRpcConnectionContext server_ctx = new TRpcConnectionContext(this.client_, inputProtocol, outputProtocol);
                while (!TThreadPoolServer.this.stopped_ && processor.process(inputProtocol, outputProtocol, server_ctx)) {
                }
            }
            catch (TTransportException server_ctx) {
            }
            catch (TException tx) {
                LOGGER.error("Thrift error occurred during processing of message.", tx);
            }
            catch (Exception x) {
                LOGGER.error("Error occurred during processing of message.", x);
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport != null) {
                outputTransport.close();
            }
        }
    }

    public static class Options {
        public int minWorkerThreads = 5;
        public int maxWorkerThreads = Integer.MAX_VALUE;
        public int stopTimeoutVal = 60;
        public TimeUnit stopTimeoutUnit = TimeUnit.SECONDS;
        public BlockingQueue<Runnable> executorQueue = null;
        public RejectedExecutionHandler rejectedExecutionHandler = null;
        public ExecutorService executorService = null;
    }
}

