/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.com.facebook.thrift.utils;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ByteBufferUtils {
    public static final byte[] EMPTY_BYTES = new byte[0];
    public static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    private ByteBufferUtils() {
    }

    public static byte[] toBytes(ByteBuffer buffer) {
        if (buffer == null) {
            return EMPTY_BYTES;
        }
        if (buffer.hasArray() && buffer.arrayOffset() == 0 && buffer.position() == 0 && buffer.limit() == buffer.capacity()) {
            return buffer.array();
        }
        ByteBuffer shallowCopy = buffer.duplicate();
        byte[] copy = new byte[shallowCopy.remaining()];
        shallowCopy.get(copy);
        return copy;
    }

    public static String toHexString(ByteBuffer buffer) {
        if (buffer == null) {
            return "null";
        }
        StringBuilder s = new StringBuilder();
        for (int i = buffer.position(); i < buffer.limit(); ++i) {
            if (i > buffer.position()) {
                s.append(' ');
            }
            s.append(String.format("%02x", buffer.get(i)));
        }
        return s.toString();
    }

    public static ByteBuffer deepCopy(ByteBuffer src) {
        if (src == null) {
            return null;
        }
        if (src.hasArray()) {
            byte[] bytes = new byte[src.remaining()];
            System.arraycopy(src.array(), src.arrayOffset() + src.position(), bytes, 0, bytes.length);
            return ByteBuffer.wrap(bytes);
        }
        ByteBuffer shallowCopy = src.duplicate();
        ByteBuffer copy = ByteBuffer.allocate(shallowCopy.remaining());
        copy.put(shallowCopy);
        copy.flip();
        return copy;
    }

    public static InputStream toInputStream(final ByteBuffer buffer) {
        if (buffer == null) {
            return new InputStream(){

                @Override
                public int read() throws IOException {
                    return -1;
                }

                @Override
                public int read(byte[] bytes, int off, int len) throws IOException {
                    return -1;
                }
            };
        }
        return new InputStream(){
            private ByteBuffer buf;
            {
                this.buf = buffer;
            }

            @Override
            public int read() throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                return this.buf.get() & 0xFF;
            }

            @Override
            public int read(byte[] bytes, int off, int len) throws IOException {
                if (!this.buf.hasRemaining()) {
                    return -1;
                }
                int n = Math.min(len, this.buf.remaining());
                this.buf.get(bytes, off, n);
                return n;
            }
        };
    }
}

