/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.bouncycastle.tsp.ers;

import java.io.IOException;
import java.util.Date;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.asn1.tsp.ArchiveTimeStamp;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.asn1.tsp.ArchiveTimeStampChain;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.asn1.tsp.ArchiveTimeStampSequence;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.asn1.tsp.EvidenceRecord;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.cert.X509CertificateHolder;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.cms.SignerInformationVerifier;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.operator.DigestCalculatorProvider;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.operator.OperatorCreationException;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.tsp.TSPException;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.tsp.ers.ERSArchiveTimeStamp;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.tsp.ers.ERSData;
import org.apache.flink.connector.nebula.shaded.org.bouncycastle.tsp.ers.ERSException;

public class ERSEvidenceRecord {
    private final EvidenceRecord evidenceRecord;
    private final DigestCalculatorProvider digestCalculatorProvider;
    private final ERSArchiveTimeStamp lastArchiveTimeStamp;

    public ERSEvidenceRecord(byte[] byArray, DigestCalculatorProvider digestCalculatorProvider) throws TSPException, ERSException {
        this(EvidenceRecord.getInstance(byArray), digestCalculatorProvider);
    }

    public ERSEvidenceRecord(EvidenceRecord evidenceRecord, DigestCalculatorProvider digestCalculatorProvider) throws TSPException, ERSException {
        this.evidenceRecord = evidenceRecord;
        this.digestCalculatorProvider = digestCalculatorProvider;
        ArchiveTimeStampSequence archiveTimeStampSequence = evidenceRecord.getArchiveTimeStampSequence();
        ArchiveTimeStampChain[] archiveTimeStampChainArray = archiveTimeStampSequence.getArchiveTimeStampChains();
        ArchiveTimeStampChain archiveTimeStampChain = archiveTimeStampChainArray[archiveTimeStampChainArray.length - 1];
        ArchiveTimeStamp[] archiveTimeStampArray = archiveTimeStampChain.getArchiveTimestamps();
        this.lastArchiveTimeStamp = new ERSArchiveTimeStamp(archiveTimeStampArray[archiveTimeStampArray.length - 1], digestCalculatorProvider);
    }

    public ERSArchiveTimeStamp getLastArchiveTimeStamp() {
        return this.lastArchiveTimeStamp;
    }

    public void validatePresent(ERSData eRSData, Date date) throws ERSException, OperatorCreationException {
        this.lastArchiveTimeStamp.validatePresent(eRSData, date);
    }

    public void validatePresent(byte[] byArray, Date date) throws ERSException, OperatorCreationException {
        this.lastArchiveTimeStamp.validatePresent(byArray, date);
    }

    public X509CertificateHolder getSigningCertificate() {
        return this.lastArchiveTimeStamp.getSigningCertificate();
    }

    public void validate(SignerInformationVerifier signerInformationVerifier) throws TSPException {
        this.lastArchiveTimeStamp.validate(signerInformationVerifier);
    }

    public byte[] getEncoded() throws IOException {
        return this.evidenceRecord.getEncoded();
    }
}

