/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.distance;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.distance.PointPairDistance;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryCollection;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineSegment;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Polygon;

public class DistanceToPoint {
    public static void computeDistance(Geometry geom, Coordinate pt, PointPairDistance ptDist) {
        if (geom instanceof LineString) {
            DistanceToPoint.computeDistance((LineString)geom, pt, ptDist);
        } else if (geom instanceof Polygon) {
            DistanceToPoint.computeDistance((Polygon)geom, pt, ptDist);
        } else if (geom instanceof GeometryCollection) {
            GeometryCollection gc = (GeometryCollection)geom;
            for (int i = 0; i < gc.getNumGeometries(); ++i) {
                Geometry g = gc.getGeometryN(i);
                DistanceToPoint.computeDistance(g, pt, ptDist);
            }
        } else {
            ptDist.setMinimum(geom.getCoordinate(), pt);
        }
    }

    public static void computeDistance(LineString line, Coordinate pt, PointPairDistance ptDist) {
        LineSegment tempSegment = new LineSegment();
        Coordinate[] coords = line.getCoordinates();
        for (int i = 0; i < coords.length - 1; ++i) {
            tempSegment.setCoordinates(coords[i], coords[i + 1]);
            Coordinate closestPt = tempSegment.closestPoint(pt);
            ptDist.setMinimum(closestPt, pt);
        }
    }

    public static void computeDistance(LineSegment segment, Coordinate pt, PointPairDistance ptDist) {
        Coordinate closestPt = segment.closestPoint(pt);
        ptDist.setMinimum(closestPt, pt);
    }

    public static void computeDistance(Polygon poly, Coordinate pt, PointPairDistance ptDist) {
        DistanceToPoint.computeDistance(poly.getExteriorRing(), pt, ptDist);
        for (int i = 0; i < poly.getNumInteriorRing(); ++i) {
            DistanceToPoint.computeDistance(poly.getInteriorRingN(i), pt, ptDist);
        }
    }
}

