/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.densify;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateList;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateSequence;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineSegment;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.MultiPolygon;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Polygon;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.PrecisionModel;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.util.GeometryTransformer;

public class Densifier {
    private Geometry inputGeom;
    private double distanceTolerance;

    public static Geometry densify(Geometry geom, double distanceTolerance) {
        Densifier densifier = new Densifier(geom);
        densifier.setDistanceTolerance(distanceTolerance);
        return densifier.getResultGeometry();
    }

    private static Coordinate[] densifyPoints(Coordinate[] pts, double distanceTolerance, PrecisionModel precModel) {
        LineSegment seg = new LineSegment();
        CoordinateList coordList = new CoordinateList();
        for (int i = 0; i < pts.length - 1; ++i) {
            seg.p0 = pts[i];
            seg.p1 = pts[i + 1];
            coordList.add(seg.p0, false);
            double len = seg.getLength();
            int densifiedSegCount = (int)(len / distanceTolerance) + 1;
            if (densifiedSegCount <= 1) continue;
            double densifiedSegLen = len / (double)densifiedSegCount;
            for (int j = 1; j < densifiedSegCount; ++j) {
                double segFract = (double)j * densifiedSegLen / len;
                Coordinate p = seg.pointAlong(segFract);
                precModel.makePrecise(p);
                coordList.add(p, false);
            }
        }
        coordList.add(pts[pts.length - 1], false);
        return coordList.toCoordinateArray();
    }

    public Densifier(Geometry inputGeom) {
        this.inputGeom = inputGeom;
    }

    public void setDistanceTolerance(double distanceTolerance) {
        if (distanceTolerance <= 0.0) {
            throw new IllegalArgumentException("Tolerance must be positive");
        }
        this.distanceTolerance = distanceTolerance;
    }

    public Geometry getResultGeometry() {
        return new DensifyTransformer(this.distanceTolerance).transform(this.inputGeom);
    }

    static class DensifyTransformer
    extends GeometryTransformer {
        double distanceTolerance;

        DensifyTransformer(double distanceTolerance) {
            this.distanceTolerance = distanceTolerance;
        }

        @Override
        protected CoordinateSequence transformCoordinates(CoordinateSequence coords, Geometry parent) {
            Coordinate[] inputPts = coords.toCoordinateArray();
            Coordinate[] newPts = Densifier.densifyPoints(inputPts, this.distanceTolerance, parent.getPrecisionModel());
            if (parent instanceof LineString && newPts.length == 1) {
                newPts = new Coordinate[]{};
            }
            return this.factory.getCoordinateSequenceFactory().create(newPts);
        }

        @Override
        protected Geometry transformPolygon(Polygon geom, Geometry parent) {
            Geometry roughGeom = super.transformPolygon(geom, parent);
            if (parent instanceof MultiPolygon) {
                return roughGeom;
            }
            return this.createValidArea(roughGeom);
        }

        @Override
        protected Geometry transformMultiPolygon(MultiPolygon geom, Geometry parent) {
            Geometry roughGeom = super.transformMultiPolygon(geom, parent);
            return this.createValidArea(roughGeom);
        }

        private Geometry createValidArea(Geometry roughAreaGeom) {
            return roughAreaGeom.buffer(0.0);
        }
    }
}

