/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryComponentFilter;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LinearRing;

public class LinearComponentExtracter
implements GeometryComponentFilter {
    private Collection lines;
    private boolean isForcedToLineString = false;

    public static Collection getLines(Collection geoms, Collection lines) {
        for (Geometry g : geoms) {
            LinearComponentExtracter.getLines(g, lines);
        }
        return lines;
    }

    public static Collection getLines(Collection geoms, Collection lines, boolean forceToLineString) {
        for (Geometry g : geoms) {
            LinearComponentExtracter.getLines(g, lines, forceToLineString);
        }
        return lines;
    }

    public static Collection getLines(Geometry geom, Collection lines) {
        if (geom instanceof LineString) {
            lines.add(geom);
        } else {
            geom.apply(new LinearComponentExtracter(lines));
        }
        return lines;
    }

    public static Collection getLines(Geometry geom, Collection lines, boolean forceToLineString) {
        geom.apply(new LinearComponentExtracter(lines, forceToLineString));
        return lines;
    }

    public static List getLines(Geometry geom) {
        return LinearComponentExtracter.getLines(geom, false);
    }

    public static List getLines(Geometry geom, boolean forceToLineString) {
        ArrayList lines = new ArrayList();
        geom.apply(new LinearComponentExtracter(lines, forceToLineString));
        return lines;
    }

    public static Geometry getGeometry(Geometry geom) {
        return geom.getFactory().buildGeometry(LinearComponentExtracter.getLines(geom));
    }

    public static Geometry getGeometry(Geometry geom, boolean forceToLineString) {
        return geom.getFactory().buildGeometry(LinearComponentExtracter.getLines(geom, forceToLineString));
    }

    public LinearComponentExtracter(Collection lines) {
        this.lines = lines;
    }

    public LinearComponentExtracter(Collection lines, boolean isForcedToLineString) {
        this.lines = lines;
        this.isForcedToLineString = isForcedToLineString;
    }

    public void setForceToLineString(boolean isForcedToLineString) {
        this.isForcedToLineString = isForcedToLineString;
    }

    @Override
    public void filter(Geometry geom) {
        if (this.isForcedToLineString && geom instanceof LinearRing) {
            LineString line = geom.getFactory().createLineString(((LinearRing)geom).getCoordinateSequence());
            this.lines.add(line);
            return;
        }
        if (geom instanceof LineString) {
            this.lines.add(geom);
        }
    }
}

