/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.quadtree;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Envelope;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.index.quadtree.DoubleBits;

public class Key {
    private Coordinate pt = new Coordinate();
    private int level = 0;
    private Envelope env = null;

    public static int computeQuadLevel(Envelope env) {
        double dy;
        double dx = env.getWidth();
        double dMax = dx > (dy = env.getHeight()) ? dx : dy;
        int level = DoubleBits.exponent(dMax) + 1;
        return level;
    }

    public Key(Envelope itemEnv) {
        this.computeKey(itemEnv);
    }

    public Coordinate getPoint() {
        return this.pt;
    }

    public int getLevel() {
        return this.level;
    }

    public Envelope getEnvelope() {
        return this.env;
    }

    public Coordinate getCentre() {
        return new Coordinate((this.env.getMinX() + this.env.getMaxX()) / 2.0, (this.env.getMinY() + this.env.getMaxY()) / 2.0);
    }

    public void computeKey(Envelope itemEnv) {
        this.level = Key.computeQuadLevel(itemEnv);
        this.env = new Envelope();
        this.computeKey(this.level, itemEnv);
        while (!this.env.contains(itemEnv)) {
            ++this.level;
            this.computeKey(this.level, itemEnv);
        }
    }

    private void computeKey(int level, Envelope itemEnv) {
        double quadSize = DoubleBits.powerOf2(level);
        this.pt.x = Math.floor(itemEnv.getMinX() / quadSize) * quadSize;
        this.pt.y = Math.floor(itemEnv.getMinY() / quadSize) * quadSize;
        this.env.init(this.pt.x, this.pt.x + quadSize, this.pt.y, this.pt.y + quadSize);
    }
}

