/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref.ExtractLineByLocation;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref.LengthIndexOfPoint;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref.LengthLocationMap;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref.LinearLocation;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref.LocationIndexOfLine;

public class LengthIndexedLine {
    private Geometry linearGeom;

    public LengthIndexedLine(Geometry linearGeom) {
        this.linearGeom = linearGeom;
    }

    public Coordinate extractPoint(double index) {
        LinearLocation loc = LengthLocationMap.getLocation(this.linearGeom, index);
        return loc.getCoordinate(this.linearGeom);
    }

    public Coordinate extractPoint(double index, double offsetDistance) {
        LinearLocation loc = LengthLocationMap.getLocation(this.linearGeom, index);
        LinearLocation locLow = loc.toLowest(this.linearGeom);
        return locLow.getSegment(this.linearGeom).pointAlongOffset(locLow.getSegmentFraction(), offsetDistance);
    }

    public Geometry extractLine(double startIndex, double endIndex) {
        double endIndex2;
        double startIndex2 = this.clampIndex(startIndex);
        boolean resolveStartLower = startIndex2 == (endIndex2 = this.clampIndex(endIndex));
        LinearLocation startLoc = this.locationOf(startIndex2, resolveStartLower);
        LinearLocation endLoc = this.locationOf(endIndex2);
        return ExtractLineByLocation.extract(this.linearGeom, startLoc, endLoc);
    }

    private LinearLocation locationOf(double index) {
        return LengthLocationMap.getLocation(this.linearGeom, index);
    }

    private LinearLocation locationOf(double index, boolean resolveLower) {
        return LengthLocationMap.getLocation(this.linearGeom, index, resolveLower);
    }

    public double indexOf(Coordinate pt) {
        return LengthIndexOfPoint.indexOf(this.linearGeom, pt);
    }

    public double indexOfAfter(Coordinate pt, double minIndex) {
        return LengthIndexOfPoint.indexOfAfter(this.linearGeom, pt, minIndex);
    }

    public double[] indicesOf(Geometry subLine) {
        LinearLocation[] locIndex = LocationIndexOfLine.indicesOf(this.linearGeom, subLine);
        double[] index = new double[]{LengthLocationMap.getLength(this.linearGeom, locIndex[0]), LengthLocationMap.getLength(this.linearGeom, locIndex[1])};
        return index;
    }

    public double project(Coordinate pt) {
        return LengthIndexOfPoint.indexOf(this.linearGeom, pt);
    }

    public double getStartIndex() {
        return 0.0;
    }

    public double getEndIndex() {
        return this.linearGeom.getLength();
    }

    public boolean isValidIndex(double index) {
        return index >= this.getStartIndex() && index <= this.getEndIndex();
    }

    public double clampIndex(double index) {
        double startIndex;
        double posIndex = this.positiveIndex(index);
        if (posIndex < (startIndex = this.getStartIndex())) {
            return startIndex;
        }
        double endIndex = this.getEndIndex();
        if (posIndex > endIndex) {
            return endIndex;
        }
        return posIndex;
    }

    private double positiveIndex(double index) {
        if (index >= 0.0) {
            return index;
        }
        return this.linearGeom.getLength() + index;
    }
}

