/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.linearref;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateList;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryFactory;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineString;

public class LinearGeometryBuilder {
    private GeometryFactory geomFact;
    private List lines = new ArrayList();
    private CoordinateList coordList = null;
    private boolean ignoreInvalidLines = false;
    private boolean fixInvalidLines = false;
    private Coordinate lastPt = null;

    public LinearGeometryBuilder(GeometryFactory geomFact) {
        this.geomFact = geomFact;
    }

    public void setIgnoreInvalidLines(boolean ignoreInvalidLines) {
        this.ignoreInvalidLines = ignoreInvalidLines;
    }

    public void setFixInvalidLines(boolean fixInvalidLines) {
        this.fixInvalidLines = fixInvalidLines;
    }

    public void add(Coordinate pt) {
        this.add(pt, true);
    }

    public void add(Coordinate pt, boolean allowRepeatedPoints) {
        if (this.coordList == null) {
            this.coordList = new CoordinateList();
        }
        this.coordList.add(pt, allowRepeatedPoints);
        this.lastPt = pt;
    }

    public Coordinate getLastCoordinate() {
        return this.lastPt;
    }

    public void endLine() {
        LineString line;
        block6: {
            Coordinate[] rawPts;
            if (this.coordList == null) {
                return;
            }
            if (this.ignoreInvalidLines && this.coordList.size() < 2) {
                this.coordList = null;
                return;
            }
            Coordinate[] pts = rawPts = this.coordList.toCoordinateArray();
            if (this.fixInvalidLines) {
                pts = this.validCoordinateSequence(rawPts);
            }
            this.coordList = null;
            line = null;
            try {
                line = this.geomFact.createLineString(pts);
            }
            catch (IllegalArgumentException ex) {
                if (this.ignoreInvalidLines) break block6;
                throw ex;
            }
        }
        if (line != null) {
            this.lines.add(line);
        }
    }

    private Coordinate[] validCoordinateSequence(Coordinate[] pts) {
        if (pts.length >= 2) {
            return pts;
        }
        Coordinate[] validPts = new Coordinate[]{pts[0], pts[0]};
        return validPts;
    }

    public Geometry getGeometry() {
        this.endLine();
        return this.geomFact.buildGeometry(this.lines);
    }
}

