/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.snapround;

import java.util.Collection;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.LineIntersector;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.RobustLineIntersector;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.PrecisionModel;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.InteriorIntersectionFinderAdder;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.MCIndexNoder;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.NodedSegmentString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.Noder;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.NodingValidator;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.SinglePassNoder;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.noding.snapround.HotPixel;

public class SimpleSnapRounder
implements Noder {
    private final PrecisionModel pm;
    private LineIntersector li;
    private final double scaleFactor;
    private Collection nodedSegStrings;

    public SimpleSnapRounder(PrecisionModel pm) {
        this.pm = pm;
        this.li = new RobustLineIntersector();
        this.li.setPrecisionModel(pm);
        this.scaleFactor = pm.getScale();
    }

    @Override
    public Collection getNodedSubstrings() {
        return NodedSegmentString.getNodedSubstrings(this.nodedSegStrings);
    }

    @Override
    public void computeNodes(Collection inputSegmentStrings) {
        this.nodedSegStrings = inputSegmentStrings;
        this.snapRound(inputSegmentStrings, this.li);
    }

    private void checkCorrectness(Collection inputSegmentStrings) {
        List resultSegStrings = NodedSegmentString.getNodedSubstrings(inputSegmentStrings);
        NodingValidator nv = new NodingValidator(resultSegStrings);
        try {
            nv.checkValid();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void snapRound(Collection segStrings, LineIntersector li) {
        List intersections = this.findInteriorIntersections(segStrings, li);
        this.computeSnaps(segStrings, (Collection)intersections);
        this.computeVertexSnaps(segStrings);
    }

    private List findInteriorIntersections(Collection segStrings, LineIntersector li) {
        InteriorIntersectionFinderAdder intFinderAdder = new InteriorIntersectionFinderAdder(li);
        MCIndexNoder noder = new MCIndexNoder();
        noder.setSegmentIntersector(intFinderAdder);
        ((SinglePassNoder)noder).computeNodes(segStrings);
        return intFinderAdder.getInteriorIntersections();
    }

    private void computeSnaps(Collection segStrings, Collection snapPts) {
        for (NodedSegmentString ss : segStrings) {
            this.computeSnaps(ss, snapPts);
        }
    }

    private void computeSnaps(NodedSegmentString ss, Collection snapPts) {
        for (Coordinate snapPt : snapPts) {
            HotPixel hotPixel = new HotPixel(snapPt, this.scaleFactor, this.li);
            for (int i = 0; i < ss.size() - 1; ++i) {
                hotPixel.addSnappedNode(ss, i);
            }
        }
    }

    public void computeVertexSnaps(Collection edges) {
        for (NodedSegmentString edge0 : edges) {
            for (NodedSegmentString edge1 : edges) {
                this.computeVertexSnaps(edge0, edge1);
            }
        }
    }

    private void computeVertexSnaps(NodedSegmentString e0, NodedSegmentString e1) {
        Coordinate[] pts0 = e0.getCoordinates();
        Coordinate[] pts1 = e1.getCoordinates();
        for (int i0 = 0; i0 < pts0.length - 1; ++i0) {
            HotPixel hotPixel = new HotPixel(pts0[i0], this.scaleFactor, this.li);
            for (int i1 = 0; i1 < pts1.length - 1; ++i1) {
                boolean isNodeAdded;
                if (e0 == e1 && i0 == i1 || !(isNodeAdded = hotPixel.addSnappedNode(e1, i1))) continue;
                e0.addIntersection(pts0[i0], i0);
            }
        }
    }
}

