/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.overlay.validate;

import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.PointLocator;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateSequence;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryFactory;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineSegment;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.MultiLineString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.overlay.validate.PolygonalLineworkExtracter;

public class FuzzyPointLocator {
    private Geometry g;
    private double boundaryDistanceTolerance;
    private MultiLineString linework;
    private PointLocator ptLocator = new PointLocator();
    private LineSegment seg = new LineSegment();

    public FuzzyPointLocator(Geometry g, double boundaryDistanceTolerance) {
        this.g = g;
        this.boundaryDistanceTolerance = boundaryDistanceTolerance;
        this.linework = this.extractLinework(g);
    }

    public int getLocation(Coordinate pt) {
        if (this.isWithinToleranceOfBoundary(pt)) {
            return 1;
        }
        return this.ptLocator.locate(pt, this.g);
    }

    private MultiLineString extractLinework(Geometry g) {
        PolygonalLineworkExtracter extracter = new PolygonalLineworkExtracter();
        g.apply(extracter);
        List linework = extracter.getLinework();
        LineString[] lines = GeometryFactory.toLineStringArray(linework);
        return g.getFactory().createMultiLineString(lines);
    }

    private boolean isWithinToleranceOfBoundary(Coordinate pt) {
        for (int i = 0; i < this.linework.getNumGeometries(); ++i) {
            LineString line = (LineString)this.linework.getGeometryN(i);
            CoordinateSequence seq = line.getCoordinateSequence();
            for (int j = 0; j < seq.size() - 1; ++j) {
                seq.getCoordinate(j, this.seg.p0);
                seq.getCoordinate(j + 1, this.seg.p1);
                double dist = this.seg.distance(pt);
                if (!(dist <= this.boundaryDistanceTolerance)) continue;
                return true;
            }
        }
        return false;
    }
}

