/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.polygonize;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.Orientation;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.PointLocation;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateArrays;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.CoordinateList;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Envelope;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.GeometryFactory;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LineString;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.LinearRing;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Polygon;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.io.WKTWriter;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.polygonize.PolygonizeDirectedEdge;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.polygonize.PolygonizeEdge;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.planargraph.DirectedEdge;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.util.Assert;

class EdgeRing {
    private GeometryFactory factory;
    private List deList = new ArrayList();
    private DirectedEdge lowestEdge = null;
    private LinearRing ring = null;
    private Coordinate[] ringPts = null;
    private List holes;
    private EdgeRing shell;
    private boolean isHole;
    private boolean isProcessed = false;
    private boolean isIncludedSet = false;
    private boolean isIncluded = false;

    public static EdgeRing findEdgeRingContaining(EdgeRing testEr, List shellList) {
        LinearRing testRing = testEr.getRing();
        Envelope testEnv = testRing.getEnvelopeInternal();
        Coordinate testPt = testRing.getCoordinateN(0);
        EdgeRing minShell = null;
        Envelope minShellEnv = null;
        for (EdgeRing tryShell : shellList) {
            LinearRing tryShellRing = tryShell.getRing();
            Envelope tryShellEnv = tryShellRing.getEnvelopeInternal();
            if (tryShellEnv.equals(testEnv) || !tryShellEnv.contains(testEnv)) continue;
            testPt = CoordinateArrays.ptNotInList(testRing.getCoordinates(), tryShellRing.getCoordinates());
            boolean isContained = false;
            if (PointLocation.isInRing(testPt, tryShellRing.getCoordinates())) {
                isContained = true;
            }
            if (!isContained || minShell != null && !minShellEnv.contains(tryShellEnv)) continue;
            minShell = tryShell;
            minShellEnv = minShell.getRing().getEnvelopeInternal();
        }
        return minShell;
    }

    public static Coordinate ptNotInList(Coordinate[] testPts, Coordinate[] pts) {
        for (int i = 0; i < testPts.length; ++i) {
            Coordinate testPt = testPts[i];
            if (EdgeRing.isInList(testPt, pts)) continue;
            return testPt;
        }
        return null;
    }

    public static boolean isInList(Coordinate pt, Coordinate[] pts) {
        for (int i = 0; i < pts.length; ++i) {
            if (!pt.equals(pts[i])) continue;
            return true;
        }
        return false;
    }

    public static List findDirEdgesInRing(PolygonizeDirectedEdge startDE) {
        PolygonizeDirectedEdge de = startDE;
        ArrayList<PolygonizeDirectedEdge> edges = new ArrayList<PolygonizeDirectedEdge>();
        do {
            edges.add(de);
            de = de.getNext();
            Assert.isTrue(de != null, "found null DE in ring");
            Assert.isTrue(de == startDE || !de.isInRing(), "found DE already in ring");
        } while (de != startDE);
        return edges;
    }

    public EdgeRing(GeometryFactory factory) {
        this.factory = factory;
    }

    public void build(PolygonizeDirectedEdge startDE) {
        PolygonizeDirectedEdge de = startDE;
        do {
            this.add(de);
            de.setRing(this);
            de = de.getNext();
            Assert.isTrue(de != null, "found null DE in ring");
            Assert.isTrue(de == startDE || !de.isInRing(), "found DE already in ring");
        } while (de != startDE);
    }

    private void add(DirectedEdge de) {
        this.deList.add(de);
    }

    public boolean isHole() {
        return this.isHole;
    }

    public void computeHole() {
        LinearRing ring = this.getRing();
        this.isHole = Orientation.isCCW(ring.getCoordinates());
    }

    public void addHole(LinearRing hole) {
        if (this.holes == null) {
            this.holes = new ArrayList();
        }
        this.holes.add(hole);
    }

    public void addHole(EdgeRing holeER) {
        holeER.setShell(this);
        LinearRing hole = holeER.getRing();
        if (this.holes == null) {
            this.holes = new ArrayList();
        }
        this.holes.add(hole);
    }

    public Polygon getPolygon() {
        LinearRing[] holeLR = null;
        if (this.holes != null) {
            holeLR = new LinearRing[this.holes.size()];
            for (int i = 0; i < this.holes.size(); ++i) {
                holeLR[i] = (LinearRing)this.holes.get(i);
            }
        }
        Polygon poly = this.factory.createPolygon(this.ring, holeLR);
        return poly;
    }

    public boolean isValid() {
        this.getCoordinates();
        if (this.ringPts.length <= 3) {
            return false;
        }
        this.getRing();
        return this.ring.isValid();
    }

    public boolean isIncludedSet() {
        return this.isIncludedSet;
    }

    public boolean isIncluded() {
        return this.isIncluded;
    }

    public void setIncluded(boolean isIncluded) {
        this.isIncluded = isIncluded;
        this.isIncludedSet = true;
    }

    private Coordinate[] getCoordinates() {
        if (this.ringPts == null) {
            CoordinateList coordList = new CoordinateList();
            for (DirectedEdge de : this.deList) {
                PolygonizeEdge edge = (PolygonizeEdge)de.getEdge();
                EdgeRing.addEdge(edge.getLine().getCoordinates(), de.getEdgeDirection(), coordList);
            }
            this.ringPts = coordList.toCoordinateArray();
        }
        return this.ringPts;
    }

    public LineString getLineString() {
        this.getCoordinates();
        return this.factory.createLineString(this.ringPts);
    }

    public LinearRing getRing() {
        if (this.ring != null) {
            return this.ring;
        }
        this.getCoordinates();
        if (this.ringPts.length < 3) {
            System.out.println(this.ringPts);
        }
        try {
            this.ring = this.factory.createLinearRing(this.ringPts);
        }
        catch (Exception ex) {
            System.out.println(this.ringPts);
        }
        return this.ring;
    }

    private static void addEdge(Coordinate[] coords, boolean isForward, CoordinateList coordList) {
        if (isForward) {
            for (int i = 0; i < coords.length; ++i) {
                coordList.add(coords[i], false);
            }
        } else {
            for (int i = coords.length - 1; i >= 0; --i) {
                coordList.add(coords[i], false);
            }
        }
    }

    public void setShell(EdgeRing shell) {
        this.shell = shell;
    }

    public boolean hasShell() {
        return this.shell != null;
    }

    public EdgeRing getShell() {
        if (this.isHole()) {
            return this.shell;
        }
        return this;
    }

    public boolean isOuterHole() {
        if (!this.isHole) {
            return false;
        }
        return !this.hasShell();
    }

    public boolean isOuterShell() {
        return this.getOuterHole() != null;
    }

    public EdgeRing getOuterHole() {
        if (this.isHole()) {
            return null;
        }
        for (int i = 0; i < this.deList.size(); ++i) {
            PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)this.deList.get(i);
            EdgeRing adjRing = ((PolygonizeDirectedEdge)de.getSym()).getRing();
            if (!adjRing.isOuterHole()) continue;
            return adjRing;
        }
        return null;
    }

    public void updateIncluded() {
        if (this.isHole()) {
            return;
        }
        for (int i = 0; i < this.deList.size(); ++i) {
            PolygonizeDirectedEdge de = (PolygonizeDirectedEdge)this.deList.get(i);
            EdgeRing adjShell = ((PolygonizeDirectedEdge)de.getSym()).getRing().getShell();
            if (adjShell == null || !adjShell.isIncludedSet()) continue;
            this.setIncluded(!adjShell.isIncluded());
            return;
        }
    }

    public String toString() {
        return WKTWriter.toLineString(new CoordinateArraySequence(this.getCoordinates()));
    }

    public boolean isProcessed() {
        return this.isProcessed;
    }

    public void setProcessed(boolean isProcessed) {
        this.isProcessed = isProcessed;
    }

    static class EnvelopeComparator
    implements Comparator {
        EnvelopeComparator() {
        }

        public int compare(Object obj0, Object obj1) {
            EdgeRing r0 = (EdgeRing)obj0;
            EdgeRing r1 = (EdgeRing)obj1;
            return r0.getRing().getEnvelope().compareTo(r1.getRing().getEnvelope());
        }
    }
}

