/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.relate;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.LineIntersector;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.PointLocator;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.algorithm.RobustLineIntersector;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Geometry;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.IntersectionMatrix;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.Edge;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.EdgeEnd;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.EdgeIntersection;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.GeometryGraph;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.Label;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.Node;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.NodeMap;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geomgraph.index.SegmentIntersector;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.relate.EdgeEndBuilder;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.relate.RelateNode;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.relate.RelateNodeFactory;
import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.util.Assert;

public class RelateComputer {
    private LineIntersector li = new RobustLineIntersector();
    private PointLocator ptLocator = new PointLocator();
    private GeometryGraph[] arg;
    private NodeMap nodes = new NodeMap(new RelateNodeFactory());
    private IntersectionMatrix im = null;
    private ArrayList isolatedEdges = new ArrayList();
    private Coordinate invalidPoint;

    public RelateComputer(GeometryGraph[] arg) {
        this.arg = arg;
    }

    public IntersectionMatrix computeIM() {
        IntersectionMatrix im = new IntersectionMatrix();
        im.set(2, 2, 2);
        if (!this.arg[0].getGeometry().getEnvelopeInternal().intersects(this.arg[1].getGeometry().getEnvelopeInternal())) {
            this.computeDisjointIM(im);
            return im;
        }
        this.arg[0].computeSelfNodes(this.li, false);
        this.arg[1].computeSelfNodes(this.li, false);
        SegmentIntersector intersector = this.arg[0].computeEdgeIntersections(this.arg[1], this.li, false);
        this.computeIntersectionNodes(0);
        this.computeIntersectionNodes(1);
        this.copyNodesAndLabels(0);
        this.copyNodesAndLabels(1);
        this.labelIsolatedNodes();
        this.computeProperIntersectionIM(intersector, im);
        EdgeEndBuilder eeBuilder = new EdgeEndBuilder();
        List ee0 = eeBuilder.computeEdgeEnds(this.arg[0].getEdgeIterator());
        this.insertEdgeEnds(ee0);
        List ee1 = eeBuilder.computeEdgeEnds(this.arg[1].getEdgeIterator());
        this.insertEdgeEnds(ee1);
        this.labelNodeEdges();
        this.labelIsolatedEdges(0, 1);
        this.labelIsolatedEdges(1, 0);
        this.updateIM(im);
        return im;
    }

    private void insertEdgeEnds(List ee) {
        for (EdgeEnd e : ee) {
            this.nodes.add(e);
        }
    }

    private void computeProperIntersectionIM(SegmentIntersector intersector, IntersectionMatrix im) {
        int dimA = this.arg[0].getGeometry().getDimension();
        int dimB = this.arg[1].getGeometry().getDimension();
        boolean hasProper = intersector.hasProperIntersection();
        boolean hasProperInterior = intersector.hasProperInteriorIntersection();
        if (dimA == 2 && dimB == 2) {
            if (hasProper) {
                im.setAtLeast("212101212");
            }
        } else if (dimA == 2 && dimB == 1) {
            if (hasProper) {
                im.setAtLeast("FFF0FFFF2");
            }
            if (hasProperInterior) {
                im.setAtLeast("1FFFFF1FF");
            }
        } else if (dimA == 1 && dimB == 2) {
            if (hasProper) {
                im.setAtLeast("F0FFFFFF2");
            }
            if (hasProperInterior) {
                im.setAtLeast("1F1FFFFFF");
            }
        } else if (dimA == 1 && dimB == 1 && hasProperInterior) {
            im.setAtLeast("0FFFFFFFF");
        }
    }

    private void copyNodesAndLabels(int argIndex) {
        Iterator i = this.arg[argIndex].getNodeIterator();
        while (i.hasNext()) {
            Node graphNode = (Node)i.next();
            Node newNode = this.nodes.addNode(graphNode.getCoordinate());
            newNode.setLabel(argIndex, graphNode.getLabel().getLocation(argIndex));
        }
    }

    private void computeIntersectionNodes(int argIndex) {
        Iterator i = this.arg[argIndex].getEdgeIterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            int eLoc = e.getLabel().getLocation(argIndex);
            Iterator eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = (EdgeIntersection)eiIt.next();
                RelateNode n = (RelateNode)this.nodes.addNode(ei.coord);
                if (eLoc == 1) {
                    n.setLabelBoundary(argIndex);
                    continue;
                }
                if (!n.getLabel().isNull(argIndex)) continue;
                n.setLabel(argIndex, 0);
            }
        }
    }

    private void labelIntersectionNodes(int argIndex) {
        Iterator i = this.arg[argIndex].getEdgeIterator();
        while (i.hasNext()) {
            Edge e = (Edge)i.next();
            int eLoc = e.getLabel().getLocation(argIndex);
            Iterator eiIt = e.getEdgeIntersectionList().iterator();
            while (eiIt.hasNext()) {
                EdgeIntersection ei = (EdgeIntersection)eiIt.next();
                RelateNode n = (RelateNode)this.nodes.find(ei.coord);
                if (!n.getLabel().isNull(argIndex)) continue;
                if (eLoc == 1) {
                    n.setLabelBoundary(argIndex);
                    continue;
                }
                n.setLabel(argIndex, 0);
            }
        }
    }

    private void computeDisjointIM(IntersectionMatrix im) {
        Geometry gb;
        Geometry ga = this.arg[0].getGeometry();
        if (!ga.isEmpty()) {
            im.set(0, 2, ga.getDimension());
            im.set(1, 2, ga.getBoundaryDimension());
        }
        if (!(gb = this.arg[1].getGeometry()).isEmpty()) {
            im.set(2, 0, gb.getDimension());
            im.set(2, 1, gb.getBoundaryDimension());
        }
    }

    private void labelNodeEdges() {
        Iterator ni = this.nodes.iterator();
        while (ni.hasNext()) {
            RelateNode node = (RelateNode)ni.next();
            node.getEdges().computeLabelling(this.arg);
        }
    }

    private void updateIM(IntersectionMatrix im) {
        for (Edge e : this.isolatedEdges) {
            e.updateIM(im);
        }
        Iterator ni = this.nodes.iterator();
        while (ni.hasNext()) {
            RelateNode node = (RelateNode)ni.next();
            node.updateIM(im);
            node.updateIMFromEdges(im);
        }
    }

    private void labelIsolatedEdges(int thisIndex, int targetIndex) {
        Iterator ei = this.arg[thisIndex].getEdgeIterator();
        while (ei.hasNext()) {
            Edge e = (Edge)ei.next();
            if (!e.isIsolated()) continue;
            this.labelIsolatedEdge(e, targetIndex, this.arg[targetIndex].getGeometry());
            this.isolatedEdges.add(e);
        }
    }

    private void labelIsolatedEdge(Edge e, int targetIndex, Geometry target) {
        if (target.getDimension() > 0) {
            int loc = this.ptLocator.locate(e.getCoordinate(), target);
            e.getLabel().setAllLocations(targetIndex, loc);
        } else {
            e.getLabel().setAllLocations(targetIndex, 2);
        }
    }

    private void labelIsolatedNodes() {
        Iterator ni = this.nodes.iterator();
        while (ni.hasNext()) {
            Node n = (Node)ni.next();
            Label label = n.getLabel();
            Assert.isTrue(label.getGeometryCount() > 0, "node with empty label found");
            if (!n.isIsolated()) continue;
            if (label.isNull(0)) {
                this.labelIsolatedNode(n, 0);
                continue;
            }
            this.labelIsolatedNode(n, 1);
        }
    }

    private void labelIsolatedNode(Node n, int targetIndex) {
        int loc = this.ptLocator.locate(n.getCoordinate(), this.arg[targetIndex].getGeometry());
        n.getLabel().setAllLocations(targetIndex, loc);
    }
}

