/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.shaded.org.locationtech.jts.operation.valid;

import org.apache.flink.connector.nebula.shaded.org.locationtech.jts.geom.Coordinate;

public class TopologyValidationError {
    public static final int ERROR = 0;
    public static final int REPEATED_POINT = 1;
    public static final int HOLE_OUTSIDE_SHELL = 2;
    public static final int NESTED_HOLES = 3;
    public static final int DISCONNECTED_INTERIOR = 4;
    public static final int SELF_INTERSECTION = 5;
    public static final int RING_SELF_INTERSECTION = 6;
    public static final int NESTED_SHELLS = 7;
    public static final int DUPLICATE_RINGS = 8;
    public static final int TOO_FEW_POINTS = 9;
    public static final int INVALID_COORDINATE = 10;
    public static final int RING_NOT_CLOSED = 11;
    public static final String[] errMsg = new String[]{"Topology Validation Error", "Repeated Point", "Hole lies outside shell", "Holes are nested", "Interior is disconnected", "Self-intersection", "Ring Self-intersection", "Nested shells", "Duplicate Rings", "Too few distinct points in geometry component", "Invalid Coordinate", "Ring is not closed"};
    private int errorType;
    private Coordinate pt;

    public TopologyValidationError(int errorType, Coordinate pt) {
        this.errorType = errorType;
        if (pt != null) {
            this.pt = pt.copy();
        }
    }

    public TopologyValidationError(int errorType) {
        this(errorType, null);
    }

    public Coordinate getCoordinate() {
        return this.pt;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return errMsg[this.errorType];
    }

    public String toString() {
        String locStr = "";
        if (this.pt != null) {
            locStr = " at or near point " + this.pt;
        }
        return this.getMessage() + locStr;
    }
}

