/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.source;

import com.vesoft.nebula.client.storage.StorageClient;
import com.vesoft.nebula.client.storage.data.BaseTableRow;
import com.vesoft.nebula.client.storage.data.EdgeTableRow;
import com.vesoft.nebula.client.storage.scan.ScanEdgeResult;
import com.vesoft.nebula.client.storage.scan.ScanEdgeResultIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.connector.nebula.source.NebulaSource;
import org.apache.flink.connector.nebula.statement.ExecutionOptions;

public class NebulaEdgeSource
extends NebulaSource {
    ScanEdgeResultIterator iterator = null;
    Iterator<EdgeTableRow> dataIterator = null;
    Iterator<Integer> scanPartIterator;

    public NebulaEdgeSource(StorageClient storageClient, ExecutionOptions executionOptions, List<Integer> scanParts) {
        super(storageClient, executionOptions);
        this.scanPartIterator = scanParts.iterator();
    }

    public void getEdgeDataRow(int part) {
        this.iterator = this.executionOptions.isNoColumn() ? this.storageClient.scanEdge(this.executionOptions.getGraphSpace(), part, this.executionOptions.getLabel(), this.executionOptions.getLimit(), this.executionOptions.getStartTime(), this.executionOptions.getEndTime(), true, true) : this.storageClient.scanEdge(this.executionOptions.getGraphSpace(), part, this.executionOptions.getLabel(), this.executionOptions.getFields(), this.executionOptions.getLimit(), this.executionOptions.getStartTime(), this.executionOptions.getEndTime(), true, true);
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.dataIterator == null && this.iterator == null && !this.scanPartIterator.hasNext()) {
            return false;
        }
        while (this.dataIterator == null || !this.dataIterator.hasNext()) {
            if (this.iterator == null || !this.iterator.hasNext()) {
                if (!this.scanPartIterator.hasNext()) break;
                this.getEdgeDataRow(this.scanPartIterator.next());
                continue;
            }
            ScanEdgeResult next = this.iterator.next();
            if (next.isEmpty()) continue;
            this.dataIterator = next.getEdgeTableRows().iterator();
        }
        if (this.dataIterator == null) {
            return false;
        }
        return this.dataIterator.hasNext();
    }

    @Override
    public BaseTableRow next() {
        return this.dataIterator.next();
    }
}

