/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.source;

import com.vesoft.nebula.client.graph.data.ValueWrapper;
import com.vesoft.nebula.client.storage.data.BaseTableRow;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.apache.flink.connector.nebula.source.NebulaConverter;
import org.apache.flink.types.Row;

public class NebulaRowConverter
implements NebulaConverter<Row> {
    @Override
    public Row convert(BaseTableRow row) throws UnsupportedEncodingException {
        List<ValueWrapper> values = row.getValues();
        Row record = new Row(values.size());
        for (int pos = 0; pos < values.size(); ++pos) {
            ValueWrapper valueWrapper = values.get(pos);
            if (valueWrapper.isNull()) {
                record.setField(pos, null);
                continue;
            }
            if (valueWrapper.isString()) {
                record.setField(pos, (Object)valueWrapper.asString());
                continue;
            }
            if (valueWrapper.isBoolean()) {
                record.setField(pos, (Object)valueWrapper.asBoolean());
                continue;
            }
            if (valueWrapper.isLong()) {
                record.setField(pos, (Object)valueWrapper.asLong());
                continue;
            }
            if (valueWrapper.isDouble()) {
                record.setField(pos, (Object)valueWrapper.asDouble());
                continue;
            }
            if (valueWrapper.isDate()) {
                record.setField(pos, (Object)valueWrapper.asDate());
                continue;
            }
            if (valueWrapper.isTime()) {
                record.setField(pos, (Object)valueWrapper.asTime());
                continue;
            }
            if (valueWrapper.isDateTime()) {
                record.setField(pos, (Object)valueWrapper.asDateTime());
                continue;
            }
            if (valueWrapper.isGeography()) {
                record.setField(pos, (Object)valueWrapper.asGeography());
                continue;
            }
            if (!valueWrapper.isDuration()) continue;
            record.setField(pos, (Object)valueWrapper.asDuration());
        }
        return record;
    }
}

