/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.source;

import com.vesoft.nebula.client.storage.StorageClient;
import com.vesoft.nebula.client.storage.data.BaseTableRow;
import com.vesoft.nebula.client.storage.data.VertexTableRow;
import com.vesoft.nebula.client.storage.scan.ScanVertexResult;
import com.vesoft.nebula.client.storage.scan.ScanVertexResultIterator;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.connector.nebula.source.NebulaSource;
import org.apache.flink.connector.nebula.statement.ExecutionOptions;

public class NebulaVertexSource
extends NebulaSource {
    ScanVertexResultIterator iterator = null;
    Iterator<VertexTableRow> dataIterator = null;
    Iterator<Integer> scanPartIterator;

    public NebulaVertexSource(StorageClient storageClient, ExecutionOptions executionOptions, List<Integer> scanParts) {
        super(storageClient, executionOptions);
        this.scanPartIterator = scanParts.iterator();
    }

    private void getVertexDataRow(int part) {
        this.iterator = this.executionOptions.isNoColumn() ? this.storageClient.scanVertex(this.executionOptions.getGraphSpace(), part, this.executionOptions.getLabel(), this.executionOptions.getLimit(), this.executionOptions.getStartTime(), this.executionOptions.getEndTime(), true, true) : this.storageClient.scanVertex(this.executionOptions.getGraphSpace(), part, this.executionOptions.getLabel(), this.executionOptions.getFields(), this.executionOptions.getLimit(), this.executionOptions.getStartTime(), this.executionOptions.getEndTime(), true, true);
    }

    @Override
    public boolean hasNext() throws Exception {
        if (this.dataIterator == null && this.iterator == null && !this.scanPartIterator.hasNext()) {
            return false;
        }
        while (this.dataIterator == null || !this.dataIterator.hasNext()) {
            if (this.iterator == null || !this.iterator.hasNext()) {
                if (!this.scanPartIterator.hasNext()) break;
                this.getVertexDataRow(this.scanPartIterator.next());
                continue;
            }
            ScanVertexResult next = this.iterator.next();
            if (next.isEmpty()) continue;
            this.dataIterator = next.getVertexTableRows().iterator();
        }
        if (this.dataIterator == null) {
            return false;
        }
        return this.dataIterator.hasNext();
    }

    @Override
    public BaseTableRow next() {
        return this.dataIterator.next();
    }
}

