/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.table;

import java.util.Arrays;
import org.apache.flink.api.common.io.InputFormat;
import org.apache.flink.connector.nebula.connection.NebulaClientOptions;
import org.apache.flink.connector.nebula.connection.NebulaStorageConnectionProvider;
import org.apache.flink.connector.nebula.statement.ExecutionOptions;
import org.apache.flink.connector.nebula.table.NebulaRowDataInputFormat;
import org.apache.flink.table.api.TableSchema;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.connector.source.InputFormatProvider;
import org.apache.flink.table.connector.source.ScanTableSource;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;

public class NebulaDynamicTableSource
implements ScanTableSource {
    private final NebulaClientOptions nebulaClientOptions;
    private final ExecutionOptions executionOptions;
    private final TableSchema tableSchema;

    public NebulaDynamicTableSource(NebulaClientOptions nebulaClientOptions, ExecutionOptions executionOptions, TableSchema tableSchema) {
        this.nebulaClientOptions = nebulaClientOptions;
        this.executionOptions = executionOptions;
        this.tableSchema = tableSchema;
    }

    public ChangelogMode getChangelogMode() {
        return ChangelogMode.insertOnly();
    }

    public ScanTableSource.ScanRuntimeProvider getScanRuntimeProvider(ScanTableSource.ScanContext runtimeProviderContext) {
        DataType[] fieldDataTypes = this.tableSchema.getFieldDataTypes();
        LogicalType[] logicalTypes = (LogicalType[])Arrays.stream(fieldDataTypes).map(DataType::getLogicalType).toArray(LogicalType[]::new);
        NebulaRowDataInputFormat inputFormat = new NebulaRowDataInputFormat(new NebulaStorageConnectionProvider(this.nebulaClientOptions), this.executionOptions, logicalTypes);
        return InputFormatProvider.of((InputFormat)inputFormat);
    }

    public DynamicTableSource copy() {
        return new NebulaDynamicTableSource(this.nebulaClientOptions, this.executionOptions, this.tableSchema);
    }

    public String asSummaryString() {
        return "NebulaDynamicTableSource";
    }
}

