/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.connector.nebula.utils;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.connector.nebula.utils.DataTypeEnum;
import org.apache.flink.connector.nebula.utils.NebulaConstant;
import org.apache.flink.connector.nebula.utils.NebulaEdge;
import org.apache.flink.connector.nebula.utils.NebulaUtils;
import org.apache.flink.connector.nebula.utils.PolicyEnum;

public class NebulaEdges
implements Serializable {
    private String edgeType;
    private List<String> propNames;
    private List<NebulaEdge> edges;
    private PolicyEnum sourcePolicy = null;
    private PolicyEnum targetPolicy = null;

    public NebulaEdges(String edgeType, List<String> propNames, List<NebulaEdge> edges, PolicyEnum sourcePolicy, PolicyEnum targetPolicy) {
        this.edgeType = edgeType;
        this.propNames = propNames;
        this.edges = edges;
        this.sourcePolicy = sourcePolicy;
        this.targetPolicy = targetPolicy;
    }

    public String getEdgeType() {
        return this.edgeType;
    }

    public String getPropNames() {
        ArrayList<String> escapePropNames = new ArrayList<String>();
        for (String propName : this.propNames) {
            escapePropNames.add(NebulaUtils.mkString(propName, "`", "", "`"));
        }
        return String.join((CharSequence)",", escapePropNames);
    }

    public List<NebulaEdge> getEdges() {
        return this.edges;
    }

    public PolicyEnum getSourcePolicy() {
        return this.sourcePolicy;
    }

    public PolicyEnum getTargetPolicy() {
        return this.targetPolicy;
    }

    public String getInsertStatement() {
        ArrayList<String> values = new ArrayList<String>();
        for (NebulaEdge edge : this.edges) {
            String sourceId = this.getSourceId(edge);
            String targetId = this.getTargetId(edge);
            if (edge.getRank() == null) {
                values.add(String.format(NebulaConstant.EDGE_VALUE_WITHOUT_RANKING_TEMPLATE, sourceId, targetId, edge.getPropValuesString()));
                continue;
            }
            values.add(String.format(NebulaConstant.EDGE_VALUE_TEMPLATE, sourceId, targetId, edge.getRank(), edge.getPropValuesString()));
        }
        return String.format(NebulaConstant.BATCH_INSERT_TEMPLATE, DataTypeEnum.EDGE.name(), this.edgeType, this.getPropNames(), String.join((CharSequence)",", values));
    }

    public String getUpdateStatement() {
        ArrayList<String> statements = new ArrayList<String>();
        for (NebulaEdge edge : this.edges) {
            String sourceId = this.getSourceId(edge);
            String targetId = this.getTargetId(edge);
            long rank = 0L;
            if (edge.getRank() != null) {
                rank = edge.getRank();
            }
            ArrayList<String> updateProps = new ArrayList<String>();
            for (int i = 0; i < this.propNames.size(); ++i) {
                updateProps.add(String.format(NebulaConstant.UPDATE_VALUE_TEMPLATE, this.propNames.get(i), edge.getPropValues().get(i)));
            }
            String updatePropsString = String.join((CharSequence)",", updateProps);
            String statement = String.format(NebulaConstant.UPDATE_EDGE_TEMPLATE, DataTypeEnum.EDGE.name(), this.edgeType, sourceId, targetId, rank, updatePropsString);
            statements.add(statement);
        }
        return String.join((CharSequence)";", statements);
    }

    public String getDeleteStatement() {
        ArrayList<String> sourceTargetIds = new ArrayList<String>();
        for (NebulaEdge edge : this.edges) {
            String sourceId = this.getSourceId(edge);
            String targetId = this.getTargetId(edge);
            long rank = 0L;
            if (edge.getRank() != null) {
                rank = edge.getRank();
            }
            String statement = String.format(NebulaConstant.EDGE_ENDPOINT_TEMPLATE, sourceId, targetId, rank);
            sourceTargetIds.add(statement);
        }
        return String.format(NebulaConstant.DELETE_EDGE_TEMPLATE, this.edgeType, String.join((CharSequence)",", sourceTargetIds));
    }

    private String getSourceId(NebulaEdge edge) {
        String sourceId = null;
        if (this.sourcePolicy == null) {
            sourceId = edge.getSource();
        } else {
            switch (this.sourcePolicy) {
                case HASH: {
                    sourceId = String.format(NebulaConstant.ENDPOINT_TEMPLATE, PolicyEnum.HASH.name(), edge.getSource());
                    break;
                }
                case UUID: {
                    sourceId = String.format(NebulaConstant.ENDPOINT_TEMPLATE, PolicyEnum.UUID.name(), edge.getSource());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("source policy is not supported");
                }
            }
        }
        return sourceId;
    }

    private String getTargetId(NebulaEdge edge) {
        String targetId = null;
        if (this.targetPolicy == null) {
            targetId = edge.getTarget();
        } else {
            switch (this.targetPolicy) {
                case HASH: {
                    targetId = String.format(NebulaConstant.ENDPOINT_TEMPLATE, PolicyEnum.HASH.name(), edge.getTarget());
                    break;
                }
                case UUID: {
                    targetId = String.format(NebulaConstant.ENDPOINT_TEMPLATE, PolicyEnum.UUID.name(), edge.getTarget());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("target policy is not supported");
                }
            }
        }
        return targetId;
    }
}

